unit Inv_satz;

interface

type
         SString   = String[128];
         MString   = String[80];
         DString   = String[20];
         IString   = String[10];
         Buch      = record
                       InvN : IString;
                       Firm : DString;
                       Zahl : String[2];
                       Titl : MString;
                       Erwb : String[2];
                       Wert : String[7];
                       SOrt : String[4];
                       Verl : String[16];
                     end;

var
         Buecher   : Array[1..320] of Buch;
         Buch1     : Buch;
         BFile,BHF : File of Buch;

Procedure Clean;
Procedure BuchInit;
Procedure BuchCopy(Source,Dest:String);
Procedure Einsort;
Procedure Aussort(TInvN:IString);

implementation

Procedure Clean;
begin
   with Buch1 do begin
     FillChar(Firm[Length(Firm)+1],20-Length(Firm),#0);
     FillChar(Titl[Length(Titl)+1],80-Length(Titl),#0);
     FillChar(SOrt[Length(SOrt)+1], 4-Length(SOrt),#0);
     FillChar(Verl[Length(Verl)+1],16-Length(Verl),#0);
   end;
end;

Procedure BuchInit;
begin   
   with Buch1 do begin
     InvN := '';
     Firm := '';
     Zahl := '';
     Titl := '';
     Erwb := '';
     Wert := '';
     SOrt := '';
     Verl := '';
   end;
end;

Procedure BuchCopy(Source,Dest:String);
begin
   AssignFile(BFile,Source);
   Reset(BFile);
   AssignFile(BHF,Dest);
   Rewrite(BHF);
   repeat
     Read(BFile,Buch1);
     Clean;
     Write(BHF,Buch1);
   until Buch1.InvN='^^^^^^^^^^';
   CloseFile(BFile);
   CloseFile(BHF);
end;

Procedure Einsort;
Var      x         : Integer;
begin
   AssignFile(BFile,'INVENTAR.DAT');
   Rename(BFile,'INVENTAR.BAK');
   Reset(BFile);
   AssignFile(BHF,'INVENTAR.DAT');
   Rewrite(BHF);
   x:=1;
   repeat
     Read(BFile,Buch1);
     while Buecher[x].InvN<Buch1.InvN do begin
       Write(BHF,Buecher[x]);
       x:=Succ(x);
     end;
     Write(BHF,Buch1);
   until Buch1.InvN='^^^^^^^^^^';
   CloseFile(BFile);
   Erase(BFile);
   CloseFile(BHF);
end;

Procedure Aussort(TInvN: IString);
Var Buch1: Buch;
begin
   Rename(BFile,'INVENTAR.BAK');
   Reset(BFile);
   AssignFile(BHF,'INVENTAR.DAT');
   Rewrite(BHF);
   while not EOF(BFile) do begin
     Read(BFile,Buch1);
     if Buch1.InvN<>TInvN then Write(BHF,Buch1);
   end;
   CloseFile(BFile);
   Erase(BFile);
   CloseFile(BHF);
end;

begin
end.
