unit Inv_main;

interface

uses
  Inv_satz, Inv_dlg, Inv_Info, Inv_Form, Inv_Show,
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, Printers, Buttons;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    PrintDialog1: TPrintDialog;
    Datei1: TMenuItem;
    Bearbeiten1: TMenuItem;
    Suchen1: TMenuItem;
    Hilfe1: TMenuItem;
    ffnen1: TMenuItem;
    Speichern1: TMenuItem;
    Speichernunter1: TMenuItem;
    Drucken1: TMenuItem;
    Beenden1: TMenuItem;
    Einfgen1: TMenuItem;
    Korrigieren1: TMenuItem;
    Ort1: TMenuItem;
    Inventarnummer1: TMenuItem;
    Lschen1: TMenuItem;
    Inventarnummer2: TMenuItem;
    Titel1: TMenuItem;
    Firma1: TMenuItem;
    Hilfethemen1: TMenuItem;
    Info1: TMenuItem;
    Importieren1: TMenuItem;
    Exportieren1: TMenuItem;
    procedure ffnen1Click(Sender: TObject);
    procedure Speichernunter1Click(Sender: TObject);
    procedure Drucken1Click(Sender: TObject);
    procedure Speichern1Click(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure CloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Korrigieren1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Einfgen1Click(Sender: TObject);
    procedure Inventarnummer2Click(Sender: TObject);
    procedure Ort1Click(Sender: TObject);
    procedure Inventarnummer1Click(Sender: TObject);
    procedure Titel1Click(Sender: TObject);
    procedure Firma1Click(Sender: TObject);
    procedure Lschen1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
         MaxInvLin : Integer;
         i,j,k,l   : Integer;
         C,T,Taste : Char;
         LST       : Text;
         DName,BDat: SString;
         P,OK      : Boolean;
         InitStr   : String;
         c1        : String;
         Inv_Modi  : Boolean;
         Inv_Load  : Boolean;
         HKey      : Integer;

implementation

{$R *.DFM}

Procedure EnableMenu;
begin
   with Form1 do begin
     Speichern1.Enabled := True;
     Speichernunter1.Enabled := True;
     Drucken1.Enabled := True;
     Korrigieren1.Enabled := True;
     Ort1.Enabled := True;
     Inventarnummer1.Enabled := True;
     Lschen1.Enabled := True;
     Inventarnummer2.Enabled := True;
     Titel1.Enabled := True;
     Firma1.Enabled := True;
   end;
end;

Function BuchTest(Cap:String): IString;
Var      C         : Char;
         P         : Boolean;
         TInvN     : IString;
begin
   with Form2 do begin
     Reset(BFile);
     repeat
       Caption :=Cap;
       Label1.Caption := 'Inv._Nr';
       Edit1.Text := '';
       Edit1.MaxLength := 10;
       if ShowModal <> mrCancel then begin
         TInvN := Edit1.Text;
         P:=False;
         Seek(BFile,0);
         repeat
           Read(BFile,Buch1);
           if Buch1.InvN=TInvN then begin
             BuchAusg;

             Form4.Left := Form1.Left+4;
             Form4.Top  := Form1.Top+40;
             Form4.ClientHeight := Form1.ClientHeight;
             Form4.Label9.Caption := Cap + ' - Auswahl';
             if Form4.ShowModal=mrOK then begin
               P:=True;
             end;

           end;
         until EOF(BFile) or P;
         if not P then begin
    {   Displ('Inventarnummer nicht gefunden!',HiBlink);}
         end;
       end
       else begin
         P:=True;
         TInvN:='^^^^^^^^^^';
       end;
     until P;
   end;
   CloseFile(BFile);
   BuchTest:=TInvN;
end;

Procedure InvList(TeilL: Boolean);
Const    S1='                                                          ';
         S2='                                           ';
Var      W         : Array[1..2] of String[132];
         W0,W1     : String[132];
         AIN       : SString;
         x,y,z     : Integer;
         C         : Char;

  Function EndList: Boolean;
  begin
    EndList:=((Buch1.InvN='^^^^^^^^^^') OR
              (TeilL AND (Buch1.Zahl='##') AND (Buch1.InvN>AIN)));
  end;

  Procedure Zeile;
  begin
    with Buch1 do begin
      Delete(W[1],1,Length(Firm));
      Insert(Firm,W[1],1);
      Delete(W[1],24,Length(Zahl));
      Insert(Zahl,W[1],24);
      Delete(W[x],72,Length(InvN));
      Insert(InvN,W[x],72);
      Delete(W[x],85,Length(Erwb));
      Insert(Erwb,W[x],85);
      Delete(W[x],90,Length(Wert));
      Insert(Wert,W[x],90);
      Delete(W[x],100,Length(SOrt));
      Insert(SOrt,W[x],100);
      Insert(Verl,W[x],107);
    end;
    if (EndList) then begin
      if (z<>4) then while z<MaxInvLin do begin
        Writeln(LST,S1,S2);
        z:=Succ(z);
      end;
{     Write(LST,#$0C);}
    end
    else begin
      if (Buch1.Zahl='##') and (z<>4) then while z<MaxInvLin do begin
        Writeln(LST,S1,S2);
        z:=Succ(z);
      end;
      if z=MaxInvLin then begin
        Write(LST,#$0C);
        Write(LST,InitStr);
        z:=4;
        Writeln(LST);
        Writeln(LST);
        Writeln(LST,W0);
        Writeln(LST,W1);
      end;
      Writeln(LST,W[1]);
    end;
  end;

begin
   Assign(BFile,'INVENTAR.DAT');
   Reset(BFile);
   W0:='Firma  (Bestell-Nr)  Zahl Titel                      (Ger';
   W1:='';
   W0:=W0+'teNr)     Inventarnr Erwb Wert     SOrt  Verlust         ';
   W1:=W1+'';
   if TeilL then begin
     with Form2 do begin
       Caption :='Inventarliste - Startwert';
       Label1.Caption := 'Inv._Nr';
       Edit1.Text := '';
       Edit1.MaxLength := 10;
       if ShowModal <> mrCancel then begin
         AIN := Edit1.Text;
         while Length(AIN)<10 do AIN:=AIN+'0';
         repeat
           Read(BFile,Buch1);
         until ((Buch1.InvN>=AIN) OR EndList)
       end
       else TeilL := False;
     end;
   end;
   z:=4;
   Writeln(LST);
   Writeln(LST);
   Writeln(LST,W0);
   Writeln(LST,W1);
   repeat
     W[1]:=S1+S2;
     Read(BFile,Buch1);
     if Length(Buch1.Titl)>40 then begin
       x:=2;
       W[2]:=W[1];
       if z=MaxInvLin-1 then z:=MaxInvLin;
       with Buch1 do begin
         y:=Pos(':',Titl);
         if Length(Titl)-y>41 then begin
           y:=41;
           while Titl[y]<>' ' do y:=Pred(y);
           if Length(Titl)-y>41 then begin
             Delete(W[1],29,40);
             Insert(Copy(Titl,1,40),W[1],29);
             Delete(W[2],29,Length(Titl)-40);
             Insert(Copy(Titl,41,Length(Titl)-40),W[2],29);
           end
           else begin
             Delete(W[1],29,y-1);
             Insert(Copy(Titl,1,y-1),W[1],29);
             Delete(W[2],29,Length(Titl)-y);
             Insert(Copy(Titl,y+1,Length(Titl)-y),W[2],29);
           end;
         end
         else begin
           Delete(W[1],29,y+1);
           Insert(Copy(Titl,1,y+1),W[1],29);
           Delete(W[2],29,Length(Titl)-y-1);
           Insert(Copy(Titl,y+2,Length(Titl)-y-1),W[2],29);
         end;
       end;
       Zeile;
       z:=z+2;
       Writeln(LST,W[2]);
     end
     else begin
       x:=1;
       Delete(W[1],29,Length(Buch1.Titl));
       Insert(Buch1.Titl,W[1],29);
       Zeile;
       z:=z+1;
     end;
   until EndList;
   Close(BFile);
end;

procedure Suchen(C:Char);
Var      Test      : SString;
         P         : Boolean;
begin
   with Form2 do begin
     Edit1.Text:='';
     case C of
       'I' : begin
               Caption:='Suchen - Inventar-Nr.';
               Label1.Caption:='Inv.-Nr.:';
               Edit1.MaxLength:=10;
             end;
       'T' : begin
               Caption:='Suchen - Titel';
               Label1.Caption:='Titel   :';
               Edit1.MaxLength:=80;
             end;
       'F' : begin
               Caption:='Suchen - Firma';
               Label1.Caption:='Firma   :';
               Edit1.MaxLength:=20;
             end;
     end;
     if ShowModal<>mrCancel then begin
       Test:=Edit1.Text;
       if C='I' then Test[1]:=UpCase(Test[1]);
       AssignFile(BFile,'INVENTAR.DAT');
       Reset(BFile);
       MaxS:=0;
       repeat
         Read(BFile,Buch1);
         P:=False;
         with Buch1 do
           case C of
             'I' : if Copy(InvN,1,Length(Test))=Test then P:=True;
             'T' : if Copy(Titl,1,Length(Test))=Test then P:=True;
             'F' : if Copy(Firm,1,Length(Test))=Test then P:=True;
           end;
         if P and (MaxS<320) then begin
           MaxS:=Succ(MaxS);
           Buecher[MaxS]:=Buch1;
         end;
       until Buch1.InvN='^^^^^^^^^^';
       closeFile(BFile);

       Form5.Left := Form1.Left+4;
       Form5.Top  := Form1.Top+40;
       Form5.ClientHeight := Form1.ClientHeight;
       Form5.ShowModal;
     end;
   end;
end;

procedure TForm1.ffnen1Click(Sender: TObject);
Var      Test      : Boolean;
begin
   Test := True;
   if (Inv_Load or Inv_Modi) then CloseQuery(Sender, Test);
   if Test then begin
     if OpenDialog1.Execute then begin
       BuchCopy(OpenDialog1.FileName,'INVENTAR.DAT');
       Inv_Load := True;
       Inv_Modi := False;
       EnableMenu;
     end;
   end;
end;

procedure TForm1.Speichernunter1Click(Sender: TObject);
begin
   if (SaveDialog1.Execute) then begin
     OpenDialog1.FileName:=SaveDialog1.FileName;
     BuchCopy('INVENTAR.DAT',SaveDialog1.Filename);
   end;
   Inv_Modi := False;
   Inv_Load := True;
end;

procedure TForm1.Speichern1Click(Sender: TObject);
begin
   if Inv_Load then begin
     BuchCopy('INVENTAR.DAT',Opendialog1.FileName);
     Inv_Modi := False;
   end
   else Speichernunter1Click(Self);
end;

procedure TForm1.Drucken1Click(Sender: TObject);
Var     Rand : TRect;
begin
   if PrintDialog1.Execute then begin
     AssignPrn(LST);
     Printer.Orientation:=poLandscape;
     Rewrite(LST);
     Rand:=GetPaperMargin(LST);
     Rand.Top:=120;
     Rand.Left:=120;
     SetPaperMargin(LST,Rand);
     MaxInvLin:=50;
     try
       Printer.Canvas.Font.Name:='MS LineDraw';
       Printer.Canvas.Font.Size:=10;
       InvList(PrintDialog1.PrintRange=prSelection);
     finally
       CloseFile(LST);
     end;
   end;
end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.CloseQuery(Sender: TObject; var CanClose: Boolean);
const QueryText = 'Speichern der Inventar-Datei?';
begin
   canClose := True;
   if Inv_Modi then begin
     case MessageDlg(QueryText, mtConfirmation,[mbYes, mbNo, mbCancel], 0) of
       id_Yes: Speichern1Click(Self);
       id_Cancel: CanClose := False;
     end;
   end;
end;

procedure TForm1.Korrigieren1Click(Sender: TObject);
Var      TInvN     : IString;
         x         : Integer;
begin
   TInvN:='';
   x:=1;
   repeat
     AssignFile(BFile,'INVENTAR.DAT');
     TInvN:=BuchTest('Korrigieren');
     if TInvN<>'^^^^^^^^^^' then begin
       Aussort(TInvN);
       with Form4 do begin
         Left := Form1.Left+4;
         Top  := Form1.Top+40;
         ClientHeight := Form1.ClientHeight;
         Greyed := False;
         Label9.Caption := 'Korrigieren';
         if ShowModal=mrOK then begin
           BuchEing;
           Inv_Modi := True;
         end;
         Greyed := True;
       end;
       Buecher[x]:=Buch1;
       x:=Succ(x);
     end;
   until TInvN='^^^^^^^^^^';
   Buecher[x].InvN:='^^^^^^^^^^';
   Einsort;
end;

procedure TForm1.Lschen1Click(Sender: TObject);
Var      TInvN     : IString;
         x         : Integer;
begin
   TInvN:='';
   repeat
     AssignFile(BFile,'INVENTAR.DAT');
     TInvN:=BuchTest('Lschen');
     if TInvN<>'^^^^^^^^^^' then begin
       Aussort(TInvN);
       Inv_Modi := True;
     end;
   until TInvN='^^^^^^^^^^';
end;

procedure TForm1.Einfgen1Click(Sender: TObject);
Var      x,y,z     : Integer;
begin
   Buecher[1].InvN:='^^^^^^^^^^';
   x:=0;
   BuchInit;
   BuchAusg;
   repeat
     with Form4 do begin
       Left := Form1.Left+4;
       Top  := Form1.Top+40;
       ClientHeight := Form1.ClientHeight;
       Greyed := False;
       BitBtn2.Enabled := False;
       Label9.Caption := 'Eingabe';
       HKey := ShowModal;
       if HKey=mrOK then begin
         BuchEing;
         y:=0;
         repeat
           y:=Succ(y);
         until (Buecher[y].InvN>Buch1.InvN) or (y=79);
         if y<>79 then begin
           for z:=79 downto y do Buecher[z+1]:=Buecher[z];
           Buecher[y]:=Buch1;
         end;
         x:=Succ(x);
       end;
       Greyed := True;
     end;
   until (HKey=mrCancel) or (x=79);
   if (Inv_Load=False) and (Inv_Modi=False) then begin
     if (x>0) then begin
       AssignFile(BFile,'INVENTAR.DAT');
       Rewrite(BFile);
       x:=0;
       repeat
         x:=Succ(x);
         Write(BFile,Buecher[x]);
       until Buecher[x].InvN='^^^^^^^^^^';
       CloseFile(BFile);
       EnableMenu;
       Inv_Modi:=True;
     end;
   end
   else begin
     Einsort;
     Inv_Modi:=True;
   end;
end;

procedure TForm1.Ort1Click(Sender: TObject);
Var      TInvN,TOrt,NOrt: SString;
begin
   with Form2 do begin
     Caption :='Korrektur - Ort';
     Label1.Caption := 'Inv._Nr';
     Edit1.Text := '';
     if ShowModal <> mrCancel then begin
       TInvN:=Edit1.Text;
       i:=Length(TInvN);
       Label1.Caption :='Ort alt:';
       Edit1.Text := '';
       Label2.Caption :='Ort neu:';
       Edit2.Text := '';
       TwoLines := True;
       if ShowModal<>mrCancel then begin
         TOrt:=Edit1.Text;
         NOrt:=Edit2.Text;
         AssignFile(BFile,'INVENTAR.DAT');
         Rename(BFile,'INVENTAR.BAK');
         Reset(BFile);
         AssignFile(BHF,'INVENTAR.DAT');
         Rewrite(BHF);
         Seek(BFile,0);
         repeat
           Read(BFile,Buch1);
           if Copy(Buch1.InvN,1,i)=TInvN then begin
             if (Buch1.SOrt=TOrt) then
               Buch1.SOrt:=NOrt;
           end;
           Write(BHF,Buch1);
         until EOF(BFile);
         CloseFile(BFile);
         Erase(BFile);
         CloseFile(BHF);
       end;
       TwoLines := False;
     end;
   end;
end;

procedure TForm1.Inventarnummer1Click(Sender: TObject);
Var      TInvN,NInv: SString;
         x         : Integer;
begin
   with Form2 do begin
     TwoLines := True;
     Caption :='Korrektur - Inv._Nr';
     Label1.Caption := 'Inv._Nr alt:';
     Edit1.Text := '';
     Edit1.MaxLength := 10;
     Label2.Caption := 'Inv._Nr neu:';
     Edit2.Text := '';
     Edit2.MaxLength := 10;
     repeat
       HKey := ShowModal;
       if HKey<>mrCancel then begin
         TInvN:=Edit1.Text;
         i:=Length(TInvN);
         NInv:=Edit2.Text;
       end;
     until (i=Length(NInv)) or (HKey=mrCancel);
     TwoLines:=False;
   end;
   if HKey<>mrCancel then begin
     x:=1;
     AssignFile(BFile,'INVENTAR.DAT');
     Rename(BFile,'INVENTAR.BAK');
     Reset(BFile);
     AssignFile(BHF,'INVENTAR.DAT');
     Rewrite(BHF);
     Seek(BFile,0);
     repeat
       Read(BFile,Buch1);
       if Copy(Buch1.InvN,1,i)=TInvN then begin
         Buch1.InvN:=NInv+Copy(Buch1.InvN,i+1,10-i);
         Buecher[x]:=Buch1;
         x:=Succ(x);
       end
       else Write(BHF,Buch1);
     until EOF(BFile);
     CloseFile(BFile);
     Erase(BFile);
     CloseFile(BHF);
     Buecher[x].InvN:='^^^^^^^^^^';
     Einsort;
   end;
end;

procedure TForm1.Inventarnummer2Click(Sender: TObject);
begin
   Suchen('I');
end;

procedure TForm1.Titel1Click(Sender: TObject);
begin
   Suchen('T');
end;

procedure TForm1.Firma1Click(Sender: TObject);
begin
   Suchen('F');
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
   with Form3 do begin
      ShowModal;
   end;
end;

end.
