unit TC_Form;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, IniFiles,
  JCLUnicode, JCLAnsiStrings, JCLWideStrings;

type
  THtmlChar = record
    UniChar: WideChar;
    Level  : Word;
    HtmlStr: WideString;
  end;
  THtmlArr = Array [0..127] of THtmlChar;

  TConvHlp = class(TObject)
    QCodeP: Word;
    ZCodeP: Word;
    HtmlEn: Word;
    HtmlDe: Word;
    CLineB: Boolean;
    TTrailBl : Boolean;
    CTabWidth: Boolean;
    QTabWidth: Word;
    ZTabWidth: Word;
  private
    FileNameI: string;
    FileNameO: String;
    AnsiQLineB: AnsiString;
    AnsiZLineB: AnsiString;
    AnsiSLineB: AnsiString;
    WideQLineB: WideString;
    WideZLineB: WideString;
    WideSLineB: WideString;
    QLineB: Word;
    ZLineB: Word;
    Procedure setFilename(Value: string);
    Procedure SetQLineBreak(Value: Word);
    Procedure SetZLineBreak(Value: Word);
    Function UniTabExpand(InStr: WideString): WideString;
    Function UniTabCompress(InStr: WideString): WideString;
    Function UniHtmlDecode(InStr: WideString): WideString;
    Function UniHtmlEncode(InStr: WideString): WideString;
  published
    property FileName: String read FileNameI write SetFilename;
    property QLineBreak: Word read QLineB write SetQLineBreak;
    property ZLineBreak: Word read ZLineB write SetZLineBreak;
 public
    Procedure AnsiFiletoAnsiFile;
    Procedure AnsiFiletoUniFile;
    Procedure UNIFiletoAnsiFile;
    Procedure UNIFiletoUNIFile;
  end;

  TForm1 = class(TForm)
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    OpenDialog1: TOpenDialog;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    CheckBox4: TCheckBox;
    Label1: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Checkbox1Click(Sender: TObject);
    procedure Checkbox2Click(Sender: TObject);
    procedure Checkbox3Click(Sender: TObject);
  private
    OEM_CP : Word;
    ANSI_CP : Word;
    DefHEnc : Word;
    DefHDec : Word;
    procedure ReadIni;
    Function CheckCP(CP: Word): Boolean;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

const
  CHtmlArr: THtmlArr = ((UniChar:'&';Level: 1;HtmlStr:'&amp;'),
                       (UniChar:'<';Level: 1;HtmlStr:'&lt;'),
                       (UniChar:'>';Level: 1;HtmlStr:'&gt;'),
                       (UniChar:'"';Level: 1;HtmlStr:'&quot;'),
                       (UniChar:WideChar($A0);Level: 2;HtmlStr:'&nbsp;'),
                       (UniChar:'';Level: 2;HtmlStr:'&iexcl;'),
                       (UniChar:'';Level: 2;HtmlStr:'&cent;'),
                       (UniChar:'';Level: 3;HtmlStr:'&pound;'),
                       (UniChar:'';Level: 2;HtmlStr:'&curren;'),
                       (UniChar:'';Level: 2;HtmlStr:'&yen;'),
                       (UniChar:'';Level: 2;HtmlStr:'&brvbar;'),
                       (UniChar:'';Level: 3;HtmlStr:'&sect;'),
                       (UniChar:'';Level: 3;HtmlStr:'&uml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&copy;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ordf;'),
                       (UniChar:'';Level: 2;HtmlStr:'&laquo;'),
                       (UniChar:'';Level: 2;HtmlStr:'&not;'),
                       (UniChar:WideChar($AD);Level: 2;HtmlStr:'&shy;'),
                       (UniChar:'';Level: 3;HtmlStr:'&reg;'),
                       (UniChar:'';Level: 3;HtmlStr:'&macr;'),
                       (UniChar:'';Level: 3;HtmlStr:'&deg;'),    //U+00B0
                       (UniChar:'';Level: 3;HtmlStr:'&plusmn;'),
                       (UniChar:'';Level: 2;HtmlStr:'&sup2;'),
                       (UniChar:'';Level: 2;HtmlStr:'&sup3;'),
                       (UniChar:'';Level: 2;HtmlStr:'&acute;'),
                       (UniChar:'';Level: 2;HtmlStr:'&micro;'),
                       (UniChar:'';Level: 2;HtmlStr:'&para;'),
                       (UniChar:'';Level: 2;HtmlStr:'&middot;'),
                       (UniChar:'';Level: 2;HtmlStr:'&cedil;'),
                       (UniChar:'';Level: 2;HtmlStr:'&sup1;'),
                       (UniChar:'';Level: 2;HtmlStr:'&ordm;'),
                       (UniChar:'';Level: 2;HtmlStr:'&raquo;'),
                       (UniChar:'';Level: 2;HtmlStr:'&frac14;'),
                       (UniChar:'';Level: 2;HtmlStr:'&frac12;'),
                       (UniChar:'';Level: 2;HtmlStr:'&frac34;'),
                       (UniChar:'';Level: 2;HtmlStr:'&iquest;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Agrave;'), //U+00C0
                       (UniChar:'';Level: 3;HtmlStr:'&Aacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Acirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Atilde;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Auml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Aring;'),
                       (UniChar:'';Level: 3;HtmlStr:'&AElig;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Ccedil;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Egrave;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Eacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Ecirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Euml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Igrave;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Iacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Icirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Iuml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ETH;'),    //U+00D0
                       (UniChar:'';Level: 3;HtmlStr:'&Ntilde;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Ograve;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Oacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Ocirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Otilde;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Ouml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&times;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Oslash;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Ugrave;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Uacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Ucirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Uuml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&Yacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&THORN;'),
                       (UniChar:'';Level: 3;HtmlStr:'&szlig;'),
                       (UniChar:'';Level: 3;HtmlStr:'&agrave;'), //U+00E0
                       (UniChar:'';Level: 3;HtmlStr:'&aacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&acirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&atilde;'),
                       (UniChar:'';Level: 3;HtmlStr:'&auml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&aring;'),
                       (UniChar:'';Level: 3;HtmlStr:'&aelig;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ccedil;'),
                       (UniChar:'';Level: 3;HtmlStr:'&egrave;'),
                       (UniChar:'';Level: 3;HtmlStr:'&eacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ecirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&euml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&igrave;'),
                       (UniChar:'';Level: 3;HtmlStr:'&iacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&icirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&iuml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&eth;'),    //U+00F0
                       (UniChar:'';Level: 3;HtmlStr:'&ntilde;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ograve;'),
                       (UniChar:'';Level: 3;HtmlStr:'&oacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ocirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&otilde;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ouml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&divide;'),
                       (UniChar:'';Level: 3;HtmlStr:'&oslash;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ugrave;'),
                       (UniChar:'';Level: 3;HtmlStr:'&uacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&ucirc;'),
                       (UniChar:'';Level: 3;HtmlStr:'&uuml;'),
                       (UniChar:'';Level: 3;HtmlStr:'&yacute;'),
                       (UniChar:'';Level: 3;HtmlStr:'&thorn;'),
                       (UniChar:'';Level: 3;HtmlStr:'&yuml;'),
                       (UniChar:WideChar($152);Level: 3;HtmlStr:'&OElig;'),
                       (UniChar:WideChar($153);Level: 3;HtmlStr:'&oelig;'),
                       (UniChar:WideChar($160);Level: 3;HtmlStr:'&Scaron;'),
                       (UniChar:WideChar($161);Level: 3;HtmlStr:'&scaron;'),
                       (UniChar:WideChar($178);Level: 3;HtmlStr:'&Yuml;'),
                       (UniChar:WideChar($17D);Level: 3;HtmlStr:'&Zcaron;'),
                       (UniChar:WideChar($17E);Level: 3;HtmlStr:'&zcaron;'),
                       (UniChar:WideChar($192);Level: 3;HtmlStr:'&fnof;'),
                       (UniChar:WideChar($2C6);Level: 3;HtmlStr:'&circ;'),
                       (UniChar:WideChar($2DC);Level: 3;HtmlStr:'&tilde;'),
                       (UniChar:WideChar($2013);Level: 3;HtmlStr:'&ndash;'),
                       (UniChar:WideChar($2014);Level: 3;HtmlStr:'&mdash;'),
                       (UniChar:WideChar($2018);Level: 3;HtmlStr:'&lsquo;'),
                       (UniChar:WideChar($2019);Level: 3;HtmlStr:'&rsquo;'),
                       (UniChar:WideChar($201A);Level: 3;HtmlStr:'&sbquo;'),  //??
                       (UniChar:WideChar($201C);Level: 3;HtmlStr:'&ldquo;'),
                       (UniChar:WideChar($201D);Level: 3;HtmlStr:'&rdquo;'),
                       (UniChar:WideChar($201E);Level: 3;HtmlStr:'&bdquo;'),
                       (UniChar:WideChar($2020);Level: 3;HtmlStr:'&dagger;'),
                       (UniChar:WideChar($2021);Level: 3;HtmlStr:'&Dagger;'),
                       (UniChar:WideChar($2022);Level: 3;HtmlStr:'&bull;'),
                       (UniChar:WideChar($2026);Level: 3;HtmlStr:'&hellip;'),
                       (UniChar:WideChar($2030);Level: 3;HtmlStr:'&permil;'),
                       (UniChar:WideChar($2039);Level: 3;HtmlStr:'&lsaquo;'),
                       (UniChar:WideChar($203A);Level: 3;HtmlStr:'&rsaquo;'),
                       (UniChar:WideChar($20AC);Level: 3;HtmlStr:'&euro;'),
                       (UniChar:WideChar($2122);Level: 3;HtmlStr:'&trade;'),
                       (UniChar:'''';Level: 1;HtmlStr:'&apos;'));

var
  Form1: TForm1;
  HTMLArr: Array of THTMLChar;
implementation

{$R *.DFM}

Procedure TConvHlp.setFilename(Value: string);
begin
   FileNameI := Value;
   FileNameO := Value+'.OUT';
end;

Procedure TConvHlp.setQLineBreak(Value: Word);
begin
   QLineB := Value;
   case Value of
     0 : begin
           AnsiQLineB := AnsiCrLF;
           WideQLineB := WideCrLf;
         end;
     1 : begin
           AnsiQLineB := AnsiLineFeed;
           WideQLineB := WideLineFeed;
         end;
     2 : begin
           AnsiQLineB := AnsiCarriageReturn;
           WideQLineB := WideCarriageReturn;
         end;
     3 : begin
           AnsiQLineB := AnsiCrLF;
           WideQLineB := WideLineSeparator;
         end;
     4 : begin
           AnsiQLineB := AnsiCrLF;
           WideQLineB := WideParagraphSeparator;
         end;
   else  begin
           AnsiQLineB := AnsiLineBreak;
           WideQLineB := WideLineBreak;
         end;
   end;
end;
Procedure TConvHlp.setZLineBreak(Value: Word);
begin
   ZLineB := Value;
   case Value of
     0 : begin
           AnsiZLineB := AnsiCrLF;
           WideZLineB := WideCrLf;
         end;
     1 : begin
           AnsiZLineB := AnsiLineFeed;
           WideZLineB := WideLineFeed;
         end;
     2 : begin
           AnsiZLineB := AnsiCarriageReturn;
           WideZLineB := WideCarriageReturn;
         end;
     3 : begin
           AnsiZLineB := AnsiCrLF;
           WideZLineB := WideLineSeparator;
         end;
     4 : begin
           AnsiZLineB := AnsiCrLF;
           WideZLineB := WideParagraphSeparator;
         end;
   else  begin
           AnsiZLineB := AnsiLineBreak;
           WideZLineB := WideLineBreak;
         end;
   end;
end;

Function TConvHlp.UniTabExpand(InStr: WideString): WideString;
var TempWS : WideString;
    oPos   : Word;
    iPos   : Word;
    sLen   : Word;
begin
   oPos:=1;
   iPos:=1;
   sLen:=Length(InStr);
   TempWS:='';
   while sLen>=iPos do begin
     if Instr[iPos]=WideTabulator then begin
       TempWS:=TempWS+WideSpace;
       Inc(oPos);
       while ((oPos-1) mod QTabWidth)<>0 do begin
         TempWS:=TempWS+WideSpace;
         Inc(oPos);
       end;
       Inc(iPos);
     end
     else begin
       TempWS:=TempWS+InStr[iPos];
       Inc(iPos);
       Inc(oPos);
     end;
   end;
   Result:=TempWS;
end;

Function TConvHlp.UniTabCompress(InStr: WideString): WideString;
//var TempWS : WideString;
begin
   Result:=InStr;
end;

Function TConvHlp.UniHtmlDecode(InStr: WideString): WideString;
var TempWS : WideString;
    HtmlWS : WideString;
    sPos   : Word;
    iPos   : Word;
    sLen   : Word;
    cVal   : Word;
    i      : Integer;
    Decod  : Boolean;
begin
   iPos:=1;
   sLen:=Length(InStr);
   TempWS:='';
   while sLen>=iPos do begin
     if Instr[iPos]=WideChar($26) then begin
       sPos:=iPos;
       HtmlWS:='';
       while (sLen>=sPos) and (InStr[sPos]<>WideChar($3B)) do begin
         HtmlWS:=HtmlWS+InStr[sPos];
         Inc(sPos);
       end;
       if InStr[sPos]=WideChar($3B) then begin    // &-Escape komplett
         Decod:=False;
         HtmlWS:=HtmlWS+InStr[sPos];
         Inc(sPos);
         if HtmlWS[2]=WideChar($23) then begin    // Wert
           cVal:=0;
           if HtmlWS[3]=WideChar($78) then begin  // Hex-Wert
             i:=4;
             while HtmlWS[i]<>WideChar($3B) do begin
               cVal:=cVal*16;
               case HtmlWS[i] of
                 WideChar($30)..WideChar($39):
                     begin
                       Decod:=True;
                       cVal:=cVal+Ord(HtmlWS[i])-Ord(WideChar($30));
                       Inc(i);
                     end;
                 WideChar($41)..WideChar($46):
                     begin
                       Decod:=True;
                       cVal:=cVal+10+Ord(HtmlWS[i])-Ord(WideChar($41));
                       Inc(i);
                     end;
                 WideChar($61)..WideChar($66):
                     begin
                       Decod:=True;
                       cVal:=cVal+10+Ord(HtmlWS[i])-Ord(WideChar($61));
                       Inc(i);
                     end;
                 else begin
                   Decod:=False;
                   Break;
                 end;
               end;
             end;
           end                                    // Hex-Wert
           else begin                             // Num-Wert
             i:=3;
             while HtmlWS[i]<>WideChar($3B) do begin
               cVal:=cVal*10;
               if HtmlWS[i] in [WideChar($30)..WideChar($39)] then begin
                 Decod:=True;
                 cVal:=cVal+Ord(HtmlWS[i])-Ord(WideChar($30));
                 Inc(i);
               end
               else begin
                 Decod:=False;
                 Break;
               end;
             end;
           end;                                   // Hex-Wert
           if Decod then
             TempWS:=TempWS+WideChar(cVal);
         end                                      // Wert
         else begin                               // String
           for i:=Low(HtmlArr) to High(HtmlArr) do
             if (HtmlArr[i].HtmlStr=HtmlWS) and
                (HtmlArr[i].Level>=HtmlDe) then begin
               TempWS:=TempWS+HtmlArr[i].UniChar;
               Decod:=True;
               Break;
             end;
         end;                                     // String
         if Decod then
           iPos:=sPos
         else begin
           TempWS:=TempWS+InStr[iPos];
           Inc(iPos);
         end;
       end                                        // &-Escape-komplett
       else begin                                 // &-Escape unvollst
         TempWS:=TempWS+InStr[iPos];
         Inc(iPos);
       end;
     end                                          // &-Escape unvollst
     else begin                                   // Normal
       TempWS:=TempWS+InStr[iPos];
       Inc(iPos);
     end;
   end;
   Result:=TempWS;
end;

Function TConvHlp.UniHtmlEncode(InStr: WideString): WideString;
var TempWS : WideString;
    HtmlWS : WideString;
    iPos   : Word;
    sLen   : Word;
    i      : Integer;

  Function HexStr(x:Word): WideString;
  const HexArr: Array[0..15] of WideChar=('0','1','2','3','4','5','6','7',
                                          '8','9','A','B','C','D','E','F');
  Var HStr: WideString;
  begin
    HStr:='';
    HStr:=HStr+HexArr[(Hi(x) div 16)];
    HStr:=HStr+HexArr[(Hi(x) mod 16)];
    HStr:=HStr+HexArr[(Lo(x) div 16)];
    HStr:=HStr+HexArr[(Lo(x) mod 16)];
    Result:=HStr;
  end;
begin
   iPos:=1;
   sLen:=Length(InStr);
   TempWS:='';
   while sLen>=iPos do begin
     if (InStr[iPos]>WideChar($7F)) or
        ((HtmlEn=1) and
         (InStr[iPos] in [WideChar($26),WideChar($3C),
                          WideChar($3F),WideChar($22)])) then begin
       HtmlWS:='';
       for i:=Low(HtmlArr) to High(HtmlArr) do begin
         if InStr[iPos]=HtmlArr[i].UniChar then
           HtmlWS:=HtmlArr[i].HtmlStr;
       end;
       if HtmlWS='' then
         HtmlWS:='&#x'+HexStr(Word(InStr[iPos]))+';';
       TempWS:=TempWS+HtmlWS;
       Inc(iPos);
     end
     else begin
       TempWS:=TempWS+InStr[iPos];
       Inc(iPos);
     end;
   end;
   Result:=TempWS;
end;

Procedure TConvHlp.AnsiFiletoAnsiFile;
var TextAnsi: TJCLAnsiStringList;
    TextUNI : TJCLWideStringList;
    i       : Integer;
    TempAS  : AnsiString;
    TempWS  : WideString;
begin
   if CLineB then begin
     AnsiSLineB := JCLAnsiStrings.AnsiLineBreak;
     JCLAnsiStrings.AnsiLineBreak := AnsiQLineB;
   end;
   TextAnsi:= TJCLAnsiStringList.Create;
   TextUNI := TJCLWideStringList.Create;
   TextAnsi.LoadFromFile(FileNameI);
   for i:=0 to TextAnsi.Count-1 do begin
     TempWS:=StringToWideStringEx(TextAnsi[i],QCodeP);
     if CTabWidth then TempWS:=UniTabExpand(TempWS);
     if HtmlEn>0  then TempWS:=UniHtmlEncode(TempWS);
     if HtmlDe>0  then TempWS:=UniHtmlDecode(TempWS);
     TextUNI.Add(TempWS);
   end;
   TextAnsi.Free;
   TextAnsi:= TJCLAnsiStringList.Create;
   for i:=0 to TextUNI.Count-1 do begin
     TempAS:=WideStringToStringEx(TextUNI[i],ZCodeP);
     if TTrailBl then TempAS:=TrimRight(TempAS);
     TextAnsi.Add(TempAS);
   end;
   if CLineB then begin
     JCLAnsiStrings.AnsiLineBreak := AnsiZLineB;
   end;
   TextAnsi.SaveToFile(FileNameO);
   if CLineB then begin
     JCLAnsiStrings.AnsiLineBreak := AnsiSLineB;
   end;
   TextAnsi.Free;
   TextUNI.Free;
end;

Procedure TConvHlp.AnsiFiletoUNIFile;
var TextAnsi: TJCLAnsiStringList;
    TextUNI : TJCLWideStringList;
    i       : Integer;
    TempWS  : WideString;
begin
   if CLineB then begin
     AnsiSLineB := JCLAnsiStrings.AnsiLineBreak;
     WideSLineB := JCLWideStrings.WideLineBreak;
     JCLAnsiStrings.AnsiLineBreak := AnsiQLineB;
   end;
   TextAnsi:= TJCLAnsiStringList.Create;
   TextUNI := TJCLWideStringList.Create;
   TextAnsi.LoadFromFile(FileNameI);
   for i:=0 to TextAnsi.Count-1 do begin
     TempWS:=StringToWideStringEx(TextAnsi[i],QCodeP);
     if CTabWidth then TempWS:=UniTabExpand(TempWS);
     if HtmlEn>0  then TempWS:=UniHtmlEncode(TempWS);
     if HtmlDe>0  then TempWS:=UniHtmlDecode(TempWS);
     if TTrailBl then TempWS:=TrimRightW(TempWS);
     TextUNI.Add(TempWS);
   end;
   if CLineB then begin
     JCLWideStrings.WideLineBreak := WideZLineB;
     JCLAnsiStrings.AnsiLineBreak := AnsiSLineB;
   end;
   TextUNI.SaveToFile(FileNameO);
   if CLineB then begin
     JCLWideStrings.WideLineBreak := WideSLineB;
   end;
   TextAnsi.Free;
   TextUNI.Free;
end;

Procedure TConvHlp.UNIFiletoAnsiFile;
var TextAnsi: TJCLAnsiStringList;
    TextUNI : TJCLWideStringList;
    i       : Integer;
    TempAS  : AnsiString;
    TempWS  : WideString;
begin
   if CLineB then begin
     AnsiSLineB := JCLAnsiStrings.AnsiLineBreak;
     WideSLineB := JCLWideStrings.WideLineBreak;
     JCLWideStrings.WideLineBreak := WideQLineB;
   end;
   TextAnsi:= TJCLAnsiStringList.Create;
   TextUNI := TJCLWideStringList.Create;
   TextUNI.LoadFromFile(FileNameI);
   for i:=0 to TextUNI.Count-1 do begin
     TempWS:=TextUNI[i];
     if CTabWidth then TempWS:=UniTabExpand(TempWS);
     if HtmlEn>0  then TempWS:=UniHtmlEncode(TempWS);
     if HtmlDe>0  then TempWS:=UniHtmlDecode(TempWS);
     TempAS:=WideStringToStringEx(TempWS,ZCodeP);
     if TTrailBl then TempAS:=TrimRight(TempAS);
     TextAnsi.Add(TempAS);
   end;
   if CLineB then begin
     JCLWideStrings.WideLineBreak := WideSLineB;
     JCLAnsiStrings.AnsiLineBreak := AnsiZLineB;
   end;
   TextAnsi.SaveToFile(FileNameO);
   if CLineB then begin
     JCLAnsiStrings.AnsiLineBreak := AnsiSLineB;
   end;
   TextAnsi.Free;
   TextUNI.Free;
end;

Procedure TConvHlp.UNIFiletoUniFile;
var TextUNI : TJCLWideStringList;
    TextUNI2: TJCLWideStringList;
    i       : Integer;
    TempWS  : WideString;
begin
   if CLineB then begin
     WideSLineB := JCLWideStrings.WideLineBreak;
     JCLWideStrings.WideLineBreak := WideQLineB;
   end;
   TextUNI := TJCLWideStringList.Create;
   TextUNI2:= TJCLWideStringList.Create;
   TextUNI.LoadFromFile(FileNameI);
   for i:=0 to TextUNI.Count-1 do begin
     TempWS:=TextUNI[i];
     if CTabWidth then TempWS:=UniTabExpand(TempWS);
     if HtmlEn>0  then TempWS:=UniHtmlEncode(TempWS);
     if HtmlDe>0  then TempWS:=UniHtmlDecode(TempWS);
     if TTrailBl then TempWS:=TrimRightW(TempWS);
     TextUNI2.Add(TempWS);
   end;
   if CLineB then begin
     JCLWideStrings.WideLineBreak := WideZLineB;
   end;
   TextUNI2.SaveToFile(FileNameO);
   if CLineB then begin
     JCLWideStrings.WideLineBreak := WideSLineB;
   end;
   TextUNI2.Free;
   TextUNI.Free;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
Var ConvHlp  : TConvHlp;
begin
   ConvHlp:=TConvHlp.Create;
   case RadioGroup1.ItemIndex of
     0: ConvHlp.QCodeP:=ANSI_CP;
     1: ConvHlp.QCodeP:=OEM_CP;
     3: ConvHlp.QCodeP:=CP_UTF7;
     4: ConvHlp.QCodeP:=CP_UTF8;
     6: ConvHlp.QCodeP:=CP_MACCP;
   else
        ConvHlp.QCodeP:=CP_ACP;
   end;
   case RadioGroup2.ItemIndex of
     0: ConvHlp.ZCodeP:=ANSI_CP;
     1: ConvHlp.ZCodeP:=OEM_CP;
     3: ConvHlp.ZCodeP:=CP_UTF7;
     4: ConvHlp.ZCodeP:=CP_UTF8;
     6: ConvHlp.ZCodeP:=CP_MACCP;
   else
        ConvHlp.ZCodeP:=CP_ACP;
   end;

   if RadioGroup1.ItemIndex=2 then
     ConvHlp.HtmlDe:=DefHDec
   else
     ConvHlp.HtmlDe:=0;

   if RadioGroup2.ItemIndex=2 then
     ConvHlp.HtmlEn:=DefHEnc
   else
     ConvHlp.HtmlEn:=0;

   if  CheckBox2.Checked and
      (RadioGroup3.ItemIndex<>RadioGroup4.ItemIndex) then begin
     ConvHlp.CLineB:=True;
     ConvHlp.QLineBreak:=RadioGroup3.ItemIndex;
     ConvHlp.ZLineBreak:=RadioGroup4.ItemIndex;
   end;

   if  CheckBox3.Checked and
      (ComboBox1.ItemIndex>0) and (ComboBox2.ItemIndex=0) then begin
     ConvHlp.CTabWidth:=True;
     ConvHlp.QTabWidth:=ComboBox1.ItemIndex*2;
     ConvHlp.ZTabWidth:=ComboBox2.ItemIndex*2;
   end
   else ConvHlp.CTabWidth:=False;

   ConvHlp.TTrailBl:=CheckBox4.Checked;

   if ((Length(Edit1.Text)>0) and FileExists(Edit1.Text)) then begin
     ConvHlp.FileName:=Edit1.Text;
     if (RadioGroup1.ItemIndex<>RadioGroup2.ItemIndex) or
        (CheckBox2.Checked or CheckBox3.Checked) then begin
       if ((RadioGroup2.ItemIndex=5) and
           (RadioGroup1.ItemIndex in [0,1,2,3,4,6])) then begin
         ConvHlp.AnsiFileToUNIFile;
       end;
       if ((RadioGroup1.ItemIndex=5) and
           (RadioGroup2.ItemIndex in [0,1,2,3,4,6])) then begin
         ConvHlp.UNIFileToAnsiFile;
       end;
       if ((RadioGroup1.ItemIndex in [0,1,2,3,4,6]) and
           (RadioGroup2.ItemIndex in [0,1,2,3,4,6])) then begin
         ConvHlp.AnsiFileToAnsiFile;
       end;
       if ((RadioGroup1.ItemIndex=5) and
           (RadioGroup2.ItemIndex=5)) then begin
         ConvHlp.UNIFileToUNIFile;
       end;
     end
     else begin
       MessageDlg('Konvertierung nicht notwendig', mtInformation, [mbOK], 0);
     end;
   end
   else begin
     MessageDlg('Datei nicht gewhlt oder vorhanden', mtWarning, [mbOK], 0);
   end;
   ConvHlp.Free;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
   if OpenDialog1.Execute then begin
     Edit1.Text := OpenDialog1.FileName;
   end;
end;

function AnsiCodePageFromLocale: AnsiString;
// determines the code page for a given locale
var
  Buf: array [0..6] of Char;
  Language: LCID;
  CP_Str  : AnsiString;
begin
  Language := GetUserDefaultLCID;
  GetLocaleInfo(Language, LOCALE_IDefaultAnsiCodePage, Buf, 6);
  CP_Str:='(CP-' + InttoStr(StrToIntDef(Buf, GetACP)) + ')';
  Result := CP_Str;
end;

function OEMCodePageFromLocale: AnsiString;
// determines the code page for a given locale
var
  Buf: array [0..6] of Char;
  Language: LCID;
  CP_Str  : AnsiString;
begin
  Language := GetUserDefaultLCID;
  GetLocaleInfo(Language, LOCALE_IDefaultCodePage, Buf, 6);
  CP_Str:='(CP-' + InttoStr(StrToIntDef(Buf, GetOEMCP)) + ')';
  Result := CP_Str;
end;

function MACCodePageFromLocale: AnsiString;
// determines the code page for a given locale
var
  Buf: array [0..6] of Char;
  Language: LCID;
  CP_Str  : AnsiString;
begin
  Language := GetUserDefaultLCID;
  GetLocaleInfo(Language, LOCALE_IDefaultMacCodePage, Buf, 6);
  CP_Str:='(CP-' + InttoStr(StrToIntDef(Buf, GetACP)) + ')';
  Result := CP_Str;
end;

Function TForm1.CheckCP(CP: Word): Boolean;
Var TestStr: WideString;
    iLen   : Integer;
begin
//  try
  TestStr:=StringToWideStringEx('BCD(+)bcd',CP);
  iLen:=Length(TestStr);
  result:=(iLen=9);
end;

Procedure TForm1.ReadIni;
Var TC_Ini  : TIniFile;
    HTMLAnsi: TStringList;
    HTMLSect: Boolean;
    i,iPos  : Integer;
    Line    : AnsiString;
begin
  HTMLAnsi:=TStringList.Create;
  try
    HTMLAnsi.LoadFromFile('TextConv.Ini');
    HTMLSect:=False;
    iPos:=0;
    for i:=0 to HTMLAnsi.Count-1 do begin
      Line:=HTMLAnsi[i];
      if Line='[HTMLConf]' then HTMLSect:=True
      else begin
        if HTMLSect and not(Line[1] in [';','[']) then begin
          SetLength(HtmlArr,iPos+1);
          HtmlArr[iPos].UniChar:=WideChar(StrtoInt(Copy(Line,1,6)));
          HtmlArr[iPos].Level:=StrtoInt(Copy(Line,8,1));
          HtmlArr[iPos].HtmlStr:=StringToWideStringEx(Copy(Line,10,Pos(';',Line)-10),CP_ACP);
          iPos:=iPos+1;
        end
        else
          if Line[1]='[' then HTMLSect:=False;
      end;
    end;
    HTMLAnsi.Free;
    TC_Ini:=TIniFile.Create('TextConv.Ini');
    DefHDec:=TC_Ini.ReadInteger('TextConv','HTMLDecodeLevel',2);
    DefHEnc:=TC_Ini.ReadInteger('TextConv','HTMLEncodeLevel',2);
    ANSI_CP:=TC_Ini.ReadInteger('TextConv','AnsiCP',CP_ACP);
    OEM_CP :=TC_Ini.ReadInteger('TextConv','OemCP',CP_OEMCP);
    TC_Ini.Free;
    Label1.Caption:='Parameter-Datei TextConv.Ini';
  except
    HTMLAnsi.Free;
    Label1.Caption:='Interne Default-Parameter';
    SetLength(HtmlArr,128);
    for i:=0 to 127 do
      HtmlArr[i]:=CHtmlArr[i];
    DefHDec:=2;
    DefHEnc:=2;
    ANSI_CP:=CP_ACP;
    OEM_CP :=CP_OEMCP;
  end;
  if ANSI_CP<>CP_ACP then
    if not CheckCP(ANSI_CP) then ANSI_CP:=CP_ACP;
  if OEM_CP<>CP_OEMCP then
    if not CheckCP(OEM_CP) then OEM_CP:=CP_OEMCP;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   ReadIni;
   if ANSI_CP=CP_ACP then
     RadioGroup1.Items[0]:=RadioGroup1.Items[0]+AnsiCodePageFromLocale
   else
     RadioGroup1.Items[0]:=RadioGroup1.Items[0]+'(CP-' + InttoStr(ANSI_CP) + ')';
   if OEM_CP=CP_OEMCP then
     RadioGroup1.Items[1]:=RadioGroup1.Items[1]+OEMCodePageFromLocale
   else
     RadioGroup1.Items[1]:=RadioGroup1.Items[1]+'(CP-' + InttoStr(OEM_CP) + ')';
     RadioGroup1.Items[6]:=RadioGroup1.Items[6]+MacCodePageFromLocale;

   RadioGroup2.Items[0]:=RadioGroup1.Items[0];
   RadioGroup2.Items[1]:=RadioGroup1.Items[1];
   RadioGroup2.Items[6]:=RadioGroup1.Items[6];
//   TRadioButton(RadioGroup1.Controls[2]).Enabled:=False;
//   TRadioButton(RadioGroup2.Controls[2]).Enabled:=False;
end;

procedure TForm1.Checkbox1Click(Sender: TObject);
begin
   if Checkbox1.Checked=False then begin
     RadioGroup1.ItemIndex:=0;
     RadioGroup2.ItemIndex:=0;
     RadioGroup1.Enabled:=False;
     RadioGroup2.Enabled:=False;
   end
   else begin
     RadioGroup1.Enabled:=True;
     RadioGroup2.Enabled:=True;
//     TRadioButton(RadioGroup1.Controls[2]).Enabled:=False;
//     TRadioButton(RadioGroup2.Controls[2]).Enabled:=False;
   end;
end;

procedure TForm1.Checkbox2Click(Sender: TObject);
begin
   if Checkbox2.Checked=False then begin
     RadioGroup3.ItemIndex:=0;
     RadioGroup4.ItemIndex:=0;
     RadioGroup3.Enabled:=False;
     RadioGroup4.Enabled:=False;
   end
   else begin
     RadioGroup3.Enabled:=True;
     RadioGroup4.Enabled:=True;
   end;
end;

procedure TForm1.Checkbox3Click(Sender: TObject);
begin
   if Checkbox3.Checked=False then begin
     ComboBox1.ItemIndex:=0;
     ComboBox2.ItemIndex:=0;
   end;
end;

end.
