{************************************************************************}
{* Include:     AD_Sonst.Inc                                            *}
{************************************************************************}
{* Inhalt:      Sonst. Applikations-Daten-Routinen fr Modul ADInfo.Pas *}
{************************************************************************}
{* Version:     0.52a   (AINFO)                                         *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       05.Apr.1994                                             *}
{************************************************************************}

{************************************************************************}
{* Routine:     DbfInfo                                                 *}
{************************************************************************}
{* Inhalt:      Identifikation von dBase-DBF und Extraktion von DLen    *}
{*              und DSat                                                *}
{* Definition:  Procedure DbfInfo;                                      *}
{************************************************************************}

Procedure DbfInfo;
begin
   if ((FBuf.DbfKen and $03) = $03) then
     with InfoRec do begin
       FTyp:=4;
       Kurz:='DBF ';
       Lang:='xBase Datenbankdatei';
       if (FBuf.DbfHSi > 256) then
	 if (FBuf.DbfHSi < 2048) then 
	   Test:=FileRead(FH,FBuf.DummyB,FBuf.DbfHSi-256)
	 else Test:=FileRead(FH,FBuf.DummyB,1792);
       DLen:=0;
       Test:=32;
       while ((Test<FBuf.DbfHSi) and (FBuf.DbfFld[Test]<>$0d)
	and (Test<2048)) do begin
	 Inc(DLen);
	 Inc(Test,32);
       end;
       DSat:=FBuf.DbfSat;
     end;
end;

{************************************************************************}
{* Routine:     WksInfo                                                 *}
{************************************************************************}
{* Inhalt:      Identifikation von Lotus-WKS und Extraktion von DLen    *}
{*              und DSat                                                *}
{* Definition:  Procedure WksInfo;                                      *}
{************************************************************************}

Procedure WksInfo;
begin
   if ((FBuf.DummyA[0] = $00) and (FBuf.DummyA[1] = $00)) then
     with InfoRec do begin
       Test:=0;
       FTyp:=4;
       Kurz:='WKS ';
       if FBuf.DummyA[4] = $04 then begin
	 Kurz[4]:='1';
	 Lang:='Lotus 1-2-3 Arbeitsblatt';
       end;
       if FBuf.DummyA[4] = $05 then begin
	 Kurz[4]:='S';
	 Lang:='Lotus Symphony 1.x Arbeitsblatt';
       end;
       if FBuf.DummyA[4] = $06 then begin
	 Kurz[4]:='2';
	 Lang:='Lotus Symphony 2.x Arbeitsblatt';
       end;
       if FBuf.DummyA[4] = $20 then begin
	 Kurz[4]:='Q';
	 Lang:='Quattro Pro 1.0-4.0 Arbeitsblatt';
       end;
       if FBuf.DummyA[4] = $21 then begin
	 Kurz[4]:='q';
	 Lang:='Quattro Pro 5.0 Arbeitsblatt';
       end;
       while ((FBuf.DummyA[Test]<>6) and (Test<256)) do
	 Test:=Test+4+FWord(Test+2);
       if (FBuf.DummyA[Test]=6) then begin
	 DLen:=FWord(Test+4);
	 if DLen=$FFFF then DLen:=0;
	 DLen:=FWord(Test+8)-DLen+1;
	 DSat:=FWord(Test+6);
	 if DSat=$FFFF then DSat:=0;
	 DSat:=Word(Test+10)-DSat+1;
       end;
     end;
end;

{************************************************************************}
{* Routine:     PTextInfo                                               *}
{************************************************************************}
{* Inhalt:      Extraktion der Zusatzinformationen fr Plain Text, RTF  *}
{*              und Postscript                                          *}
{* Definition:  Procedure PTextInfo;                                    *}
{************************************************************************}

Procedure PTextInfo;
Var      Test      : LongInt;
	 i         : Byte;
begin
   Test:=FileSeek(FH,0,2)-1;
   if (Test>250) then Test:=250;
   while ((Test>=0) and (FBuf.DummyA[Test]>$06)) do Dec(Test);
   if (Test=-1) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='PTXT';
       Lang:='Plain ASCII Text';
       Titl:='';
       if CFCompare(Addr(FBuf.Dummy0[0]),'%!PS-Adobe-') then begin
	 Kurz:='PS-x';
	 Lang:='Adobe-Postscript x';
	 Kurz[4]:=FBuf.Dummy0[11];
	 Lang[18]:=FBuf.Dummy0[11];
         i:=14;
         while (i<120) do begin
	   if FBuf.Dummy0[i]='%' then
	     if CFCompare(Addr(FBuf.Dummy0[i]),'%%Title:') then begin
	       inc(i,9);
	       while ((FBuf.Dummy0[i]<>chr(13)) and
		      (FBuf.Dummy0[i]<>chr(10))) do begin
		 Titl:=Titl+FBuf.Dummy0[i];
		 inc(i,1);
	       end;
	     end;
           inc(i,1);
         end;
       end;
       if CFCompare(Addr(FBuf.Dummy0[0]),'<HTML>') then begin
	 Kurz:='HTML';
	 i:=6;
	 while (i<=100) do begin
	   if CFCompare(Addr(FBuf.Dummy0[i]),'<TITLE>') then begin
	     inc(i,7);
	     while ((FBuf.Dummy0[i]<>'<') and (Length(Titl)<32)) do begin
	       if ((FBuf.Dummy0[i]<>chr(13)) and
		   (FBuf.Dummy0[i]<>chr(10))) then begin
		 Titl:=Titl+FBuf.Dummy0[i];
	       end;
	       inc(i,1);
	     end;
	     Titl:=TitStr(Titl,0);
	   end;
	   inc(i,1);
	 end;
       end;
       if CFCompare(Addr(FBuf.Dummy0[0]),'{\rtf') then begin
	 Kurz:='RTF ';
	 Lang:='Microsoft Rich Text Format';
         i:=5;
         while (i<=150) do begin
	   if FBuf.Dummy0[i]='{' then
	     if CFCompare(Addr(FBuf.Dummy0[i]),'{\title') then begin
	       inc(i,8);
	       while (FBuf.Dummy0[i]<>'}') do begin
		 Titl:=Titl+FBuf.Dummy0[i];
		 inc(i,1);
	       end;
	     end;
	     if CFCompare(Addr(FBuf.Dummy0[i]),'{\author') then begin
	       inc(i,9);
	       while (FBuf.Dummy0[i]<>'}') do begin
		 Crea:=Crea+FBuf.Dummy0[i];
		 inc(i,1);
	       end;
	     end;
             inc(i,1);
           end;
	 end;
       Titl:=TitStr(Titl,1);
     end;
end;

{************************************************************************}
{* Routine:     BtmInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von                                          *}
{* Autor:       Peter Karlsson                                          *}
{* Definition:  Procedure BtmInfo;                                      *}
{************************************************************************}

Procedure BtmInfo;
begin
  If (SFWord(0)=$EBBE) then begin
    with InfoRec do begin
      FTyp:=5;
      Kurz:='BTM ';
      Lang:='4DOS/NDOS komprimierte Batch';
      Titl:='';
    end;
  end else
    PTextInfo;
end;

{************************************************************************}
{* Routine:     MsgInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Information ber .MSG-Dateien            *}
{* Autor:       Peter Karlsson                                          *}
{* Definition:  Procedure MsgInfo;                                      *}
{************************************************************************}

Procedure MsgInfo;
begin
  with InfoRec do begin
    FTyp := 5;
    Kurz := 'MSG ';
    Lang := 'Fido-Massage';
    Titl := TitStr(FBuf.MsgSub,0);
  end;
end;

{************************************************************************}
{* Routine:     PktInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion der Quell-Nodenummer als Titel               *}
{* Definition:  Procedure PktInfo;                                      *}
{************************************************************************}

Procedure PktInfo;
Var      HStr      : String;
begin
   if (FBuf.PktPId=2) then
     with InfoRec do begin
       FTyp := 5;
       Kurz := 'PKT2';
       Lang := 'Fido Paket Typ 2';
       Str(FBuf.PktONo,HStr);
       Titl := '/'+HStr;
       Str(FBuf.PktONe,HStr);
       Titl := HStr+Titl;
       if (FBuf.PktCaW=Swap(FBuf.PktCaV)) then begin
	 Kurz[4] :='+';
	 Lang := Lang + '+';
	 Str(FBuf.PktOPt,HStr);
	 Titl := Titl+'.'+HStr;
	 Str(FBuf.PktOZo,HStr);
	 Titl := HStr+':'+Titl;
       end
       else begin
	 if (FBuf.PktOQZ<>0) then begin
	   Str(FBuf.PktOQZ,HStr);
	   Titl := HStr+':'+Titl;
	 end;
       end;
       Titl := TitStr(Titl,1);
     end;
end;

{************************************************************************}
{* Routine:     WordInfo                                                *}
{************************************************************************}
{* Inhalt:      Extraktion der Zusatzinformationen fr MS-Word u. Write *}
{* Definition:  Procedure WordInfo;                                     *}
{************************************************************************}

Procedure WordInfo;
Var      Adr       : Longint;
	 i         : Word;
begin
   if (SFWord(0)=$31BE) then
     with InfoRec do begin
       FTyp:=5;
       if ((FBuf.DummyA[$60]<>0) and (FBuf.DummyA[$62]=0)) then begin
	 Kurz:='WWRI';
	 Lang:='MS Windows-Write';
	 Titl:=TitStr('',0);
       end
       else begin
	 Kurz:='WORD';
	 Lang:='Microsoft Word';
	 Adr:=128*FWord($1C);
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyB,256);
	 for i:=FWord($100) to (FWord($102)-1) do
	   Titl:=Titl+FBuf.DummyB[i];
	 Titl:=TitStr(Titl,1);
	 for i:=FWord($102) to (FWord($104)-1) do 
	   Crea:=Crea+FBuf.DummyB[i];
	 Crea:=TitStr(Crea,1);
       end;
     end
   else if (SFWord(0)=$32BE) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='WWRI';
       Lang:='MS Windows-Write';
       Titl:=TitStr('',0);
     end
   else if (SFWord(0)=$9BA5) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='WFW1';
       Lang:='MS Word fr Windows 1.x';
       Test:=FileRead(FH,FBuf.DummyB,64);
       Adr := FWord($10C) + FWord($10E) * 65536 + 2;
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,256);
       Adr := FBuf.DummyA[0] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Move(FBuf.Dummy0[Adr],Titl,Sizeof(Titl));
       Titl:=TitStr(Titl,0);
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Move(FBuf.Dummy0[Adr],Crea,Sizeof(Crea));
       Crea:=TitStr(Crea,0);
     end
   else if (SFWord(0)=$DBA5) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='WFW2';
       Lang:='MS Word fr Windows 2.0';
       Test:=FileRead(FH,FBuf.DummyB,64);
       Adr := FWord($118) + FWord($11A) * 65536 + 2;
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,256);
       Adr := FBuf.DummyA[0] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Move(FBuf.Dummy0[Adr],Titl,Sizeof(Titl));
       Titl:=TitStr(Titl,0);
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Adr := Adr + FBuf.DummyA[Adr] + 1;
       Move(FBuf.Dummy0[Adr],Crea,Sizeof(Crea));
       Crea:=TitStr(Crea,0);
     end
   else PTextInfo;
end;

{************************************************************************}
{* Routine:     HelpInfo                                                *}
{************************************************************************}
{* Inhalt:      Extraktion der Zusatzinformationen fr OS/2-, Windows-  *}
{*              und Advisor-Help                                        *}
{* Definition:  Procedure HelpInfo;                                     *}
{************************************************************************}

Procedure HelpInfo;
Const    WinHlpId  : Array[0..2] of Byte = ($3f,$5F,$03);
	 AdvHlpId  : Array[0..2] of Byte = ($4C,$4E,$02);
	 Os2HlpId  : Array[0..4] of Byte = ($48,$53,$50,$10,$9B);
	 Os2InfId  : Array[0..4] of Byte = ($48,$53,$50,$01,$9B);
Var      Adr       : Longint;
	 HAdr      : Byte;
	 P         : Boolean;
begin
   if BFCompare(Addr(FBuf),Addr(WinHlpId),2) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='WHLP';
       Lang:='Windows Helptext';
       Titl:='';
       P:=False;
       Adr:=FBuf.DumLIn[1]+$37;
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,256);
       for HAdr:=0 to 240 do
	 if FBuf.Dummy0[HAdr] ='|' then begin
	   if CFCompare(Addr(FBuf.Dummy0[HAdr+1]),'CONTEXT') then begin
	     Kurz:='WH31';
	     Lang:='Windows 3.1x Helptext';
	   end;
	   if CFCompare(Addr(FBuf.Dummy0[HAdr+1]),'TOMAP') then begin
	     Kurz:='WH30';
	     Lang:='Windows 3.00 Helptext';
	   end;
	   if CFCompare(Addr(FBuf.Dummy0[HAdr+1]),'SYSTEM') then begin
	     Adr:=FWord(HAdr+8) + FBuf.DummyA[HAdr+10]*65536 + $15;
	     P:=True;
	   end;
	 end;
       if P then begin
	 if Kurz='WH31' then Inc(Adr,4);
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,256);
	 for HAdr:=0 to 39 do Titl:=Titl+FBuf.Dummy0[HAdr];
	 Titl:=TitStr(Titl,0);
       end;
     end
   else if BFCompare(Addr(FBuf),Addr(AdvHlpId),2) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='AHLP';
       Lang:='Advisor Helptext';
       Titl:='';
       for HAdr:=16 to 55 do Titl:=Titl+FBuf.Dummy0[HAdr];
       Titl:=TitStr(Titl,1);
     end
   else if BFCompare(Addr(FBuf),Addr(Os2HlpId),4) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='OHLP';
       Lang:='OS/2 Helptext';
       Titl:='';
       for HAdr:=$6B to $92 do Titl:=Titl+FBuf.Dummy0[HAdr];
       Titl:=TitStr(Titl,1);
     end
   else if BFCompare(Addr(FBuf),Addr(Os2InfId),4) then
     with InfoRec do begin
       FTyp:=5;
       Kurz:='OINF';
       Lang:='OS/2 Infotext';
       Titl:='';
       for HAdr:=$6B to $92 do Titl:=Titl+FBuf.Dummy0[HAdr];
       Titl:=TitStr(Titl,1);
     end
   else PTextInfo;
end;

