{************************************************************************}
{* Include:     AD_Music.Inc                                            *}
{************************************************************************}
{* Inhalt:      Sound-Routinen fr Modul ADInfo.Pas                     *}
{************************************************************************}
{* Version:     1.0.0.2  (AINFO)                                        *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       23.Jun.2000                                             *}
{************************************************************************}

{************************************************************************}
{* Routine:     CmfInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl und SIns fr SB-CMFs                *}
{* Definition:  Procedure CmfInfo;                                      *}
{************************************************************************}

Procedure CmfInfo;
Var      i         : Word;
begin
   if (FBuf.CmfFId='CTMF') then
     with InfoRec do begin
       FTyp:=3;
       Kurz:='CMF ';
       Lang:='Creative Music File';
       Titl:='';
       if (FBuf.CmfOMT <> 0) then begin
         i:=FBuf.CmfOMT;
         while (i<FBuf.CmfOMT+40) do begin
           Titl:=Titl+FBuf.CmfDum[i];
           i:=succ(i);
         end;
         Titl:=TitStr(Titl,1);
       end;
       if (FBuf.CmfOCN <> 0) then begin
         i:=FBuf.CmfOCN;
         while (i<FBuf.CmfOCN+40) do begin
           Crea:=Crea+FBuf.CmfDum[i];
           i:=succ(i);
         end;
         Crea:=TitStr(Crea,1);
       end;
       if (FBuf.CmfORe <> 0) then begin
         i:=FBuf.CmfORe;
         while (i<FBuf.CmfORe+40) do begin
           Comm:=Comm+FBuf.CmfDum[i];
           i:=succ(i);
         end;
         Comm:=TitStr(Comm,1);
       end;
       SIns:=FBuf.CmfNIn;
       if (FBuf.CmfVLo = 0) then begin
         Kurz[4]:='o';
         Lang:='Creative Music File V1.0';
         SIns:=SIns mod 256;
       end;
       SLen:=0;
     end;
end;

{************************************************************************}
{* Routine:     CmsInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl fr Gameblaster CMSs                *}
{* Definition:  Procedure CmsInfo;                                      *}
{************************************************************************}

Procedure CmsInfo;
Var      i         : Word;
begin
   if ((FBuf.Dummy0[0]='C') and (FBuf.Dummy0[1]='M')) then
     with InfoRec do begin
       FTyp:=3;
       Kurz:='CMS ';
       Lang:='Gameblaster CMS';
       Titl:='';
       SIns:=0;
       SLen:=0;
       for i:=2 to 13 do
         if FBuf.DummyA[i] <> $0 then Inc(SIns);
       for i:=32 to 63 do
         Titl:=Titl+FBuf.Dummy0[i];
       Titl:=TitStr(Titl,1);
       for i:=64 to 95 do
         Crea:=Crea+FBuf.Dummy0[i];
       Crea:=TitStr(Crea,1);
       for i:=96 to 127 do
         Comm:=Comm+FBuf.Dummy0[i];
       Comm:=TitStr(Comm,1);
     end;
end;

{************************************************************************}
{* Routine:     OrgInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl und SIns fr Intelligent-Organ-ORGs *}
{* Definition:  Procedure OrgInfo;                                      *}
{************************************************************************}

Procedure OrgInfo;
Var      i         : Word;
begin
   if ((FBuf.Dummy0[0]='C') and (FBuf.Dummy0[1]='M')) then
     with InfoRec do begin
       FTyp:=3;
       Kurz:='COrg';
       Lang:='Creative Intelligent Organ File';
       Titl:='';
       for i:=32 to 55 do
         Titl:=Titl+FBuf.Dummy0[i];
       Titl:=TitStr(Titl,1);
       SIns:=4;
       SLen:=0;
     end;
end;

{************************************************************************}
{* Routine:     ModInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl, SIns und SLen fr Amiga-MODs       *}
{* Definition:  Procedure ModInfo;                                      *}
{************************************************************************}

Procedure ModInfo;
begin
   if (FBuf.ExeKen=$5A4D) then ExeInfo
   else 
     with InfoRec do begin
       FTyp:=3;
       Kurz:='MOD ';
       Lang:='Soundtracker/Protracker MOD';
       Titl:=TitStr(FBuf.ModTit,0);
       FileSeek(FH,$3b6,0);
       FileRead(FH,FBuf.DummyB,140);
       if ((FBuf.ModKen='M.K.') or (FBuf.ModKen='FLT4')) then SIns:=31
       else begin
         SIns:=15;
         FileSeek(FH,$1d6,0);
         FileRead(FH,FBuf.DummyB,140);
       end;
       if (FBuf.ModTEf mod 16)=15 then SLen:=FBuf.ModTPa
       else SLen:=6;
       SLen:=Round(1.25*FBuf.ModPat*SLen);
     end;
end;

{************************************************************************}
{* Routine:     G69Info                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von STit, SIns und SLen fr 669-Module       *}
{* Definition:  Procedure G69Info;                                      *}
{************************************************************************}

Procedure G69Info;
begin
   if ((FBuf.G69Ken='if') or (FBuf.G69Ken='JN')) then 
     with InfoRec do begin
       FTyp:=3;
       Kurz:='669 ';
       if FBuf.G69Ken='JN' then Kurz[4]:='E';
       Lang:=Kurz;
       Titl:=TitStr(Copy(FBuf.G69Tit,1,32),1);
       SIns:=FBuf.G69Sam;
       SLen:=0;
     end;
end;

{************************************************************************}
{* Routine:     S3MInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von STit, SIns und SLen fr S3M-Module       *}
{* Definition:  Procedure S3MInfo;                                      *}
{************************************************************************}

Procedure S3MInfo;
begin
   if (FBuf.S3MAKe='SCRM') then 
     with InfoRec do begin
       FTyp:=3;
       Kurz:='S3M ';
       Lang:=Kurz;
       Titl:=TitStr(FBuf.S3MTit,1);
       SIns:=FBuf.S3MSam;
       SLen:=0;
     end;
end;

{************************************************************************}
{* Routine:     RolInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von SIns fr Adlib-ROLs                      *}
{* Definition:  Procedure RolInfo;                                      *}
{************************************************************************}

Procedure RolInfo;
Type     RolFNot   = packed record
                       case Boolean of
                         True : (Note   : ShortInt;
                                 Dura   : ShortInt;);
                         False: (P: Array[0..3] of Char;);
                     end;
         RolEvnt   = packed record
                       case Boolean of
                         True : (Filler : Array[1..15] of Byte;
                                 NumEvt : ShortInt;);
                         False: (P: Array[0..16] of Char;);
                     end;
         RolIEvn   = packed record
                       case Boolean of
                         True : (TimTic : ShortInt;
                                 InsNam : Array[1..9] of Char;
                                 Reser1 : Char;
                                 Reser2 : ShortInt;);
                         False: (P: Array[0..13] of Char;);
                     end;
Var      LastI     : Integer;
         Flg       : Boolean;
         RFNot     : RolFNot;
         REvnt     : RolEvnt;
         RIEvn     : RolIEvn;
         INamen    : Array[0..100] of String[9];
         Voice     : Integer;
         i,j       : Integer;

begin
   with InfoRec do begin
     FTyp:=3;
     Kurz:='ROL ';
     Lang:='Adlib ROL';
     Titl:='';
     LastI:=0;
     FileSeek(FH,203+(6*FBuf.RolTEv),0);
     for Voice:=0 to 10 do begin
       FileRead(FH,REvnt.P,17);
       while REvnt.NumEvt > 0 do begin
         FileRead(FH,RFNot.P,4);
         REvnt.NumEvt:=REvnt.NumEvt - RFNot.Dura;
       end;
       FileRead(FH,REvnt.P,17);
       for i:=1 to REvnt.NumEvt do begin
         FileRead(FH,RIEvn.P,14);
         j:=0;
         Flg:=True;
         INamen[LastI]:=RIEvn.InsNam;
         Delete(INamen[LastI],Pos(Char(0),INamen[LastI]),9);
         while ((j < LastI) and Flg) do begin
           if INamen[j]=INamen[LastI] then Flg:=False;
           j:=Succ(j);
         end;
         if Flg then LastI:=Succ(LastI);
       end;
       FileRead(FH,REvnt.P,17);
       FileSeek(FH,(6*REvnt.NumEvt),1);
       FileRead(FH,REvnt.P,17);
       FileSeek(FH,(6*REvnt.NumEvt),1);
     end;
     SIns:=LastI;
     SLen:=0;
   end;
end;

{************************************************************************}
{* Routine:     WavInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von SIns und SLen fr MS-WAVs                *}
{* Definition:  Procedure WavInfo;                                      *}
{************************************************************************}

Procedure WavInfo;
Var      Adr,Len   : LongInt;
         Len1      : LongInt;
begin
   if ((FBuf.RifTag='RIFF') and (FBuf.RifTyp='WAVE')) then
     with InfoRec do begin
       
{$IFDEF RiffInf}       
       InitRiff;
{$ENDIF}

       Adr:=12;
       Len:=FBuf.RifLen;
       while Adr<Len do begin
         FileSeek(FH,Adr,0);
         Test:=FileRead(FH,FBuf.DummyP,256);
         Len1:=FBuf.RifLen;
         if (FBuf.RifTag = 'fmt ') then begin
           FTyp:=3;
           Kurz:='WAVE';
           Lang:='Microsoft Windows-Wave';
           SIns:=FBuf.WavCha;
           SSam:=FBuf.WavMSp;
           if (SSam = 0) then begin
             SSam:=FBuf.WavSpS;
             Kurz[4]:='*';
           end;
         end;
         if (FBuf.RifTag = 'data') then begin
           SLen:=-Round(FBuf.RifLen*10.0/SSam);
         end;
         if (FBuf.RifTag = 'LIST') and (FBuf.RifTyp = 'INFO') then
           InfoRiff(Adr,Len1);
         Adr:=Adr+Len1+8;
       end;
     end;
end;

{************************************************************************}
{* Routine:     VocInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von SIns und SLen fr SB-VOCs                *}
{* Definition:  Procedure VocInfo;                                      *}
{************************************************************************}

Procedure VocInfo;
Var      Adr,Spd   : Longint;
         Spd2      : Longint;
         MaxAdr    : Longint;
         Len       : Word;
         Fak,Rep,CF: Word;
         NewT      : Boolean;
begin
   if (FBuf.VocHea='Creative Voice File') then
     with InfoRec do begin
       NewT:=False;
       FTyp:=3;
       Kurz:='VOC ';
       Lang:='Creative Voice File';
       SIns:=1;
       Titl:='';
       Len:=0;
       Fak:=1;
       Rep:=1;
       CF:=1;
       Adr:=FBuf.VocOfs;
       if (FBuf.VocVer = $0114) then Kurz[4]:='2';
       MaxAdr:=FileSeek(FH,0,2);
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyB,64);
       if (FBuf.VocTyp > 10) then begin
         Adr:=Adr mod 256;
         FileSeek(FH,Adr,0);
         Test:=FileRead(FH,FBuf.DummyB,64);
       end;
       while ((FBuf.VocTyp<>0) and (FBuf.VocTyp<20)) and
              (Adr<=MaxAdr) do begin
         case (FBuf.VocTyp) of
           1: begin
                if (FBuf.VocDum[5]<3) then Fak:=FBuf.VocDum[5]+1;
                if NewT then Spd:=Spd2
                else Spd:=Round(1000000/(256-FBuf.VocDum[4]));
                Len:=Len+Round(100*Fak*Rep*Long3(FBuf.VocLen)/(Spd*CF));
              end;
           2: Len:=Len+Round(100*Fak*Rep*Long3(FBuf.VocLen)/Spd);
           3: begin
                Spd:=Round(1000000/(256-FBuf.VocDum[6]));
                Len:=Len+Round(100*Rep*(FBuf.VocDum[4]+FBuf.VocDum[5]*256)/Spd);
              end;
           5: begin
                Test:=4;
                while ((Length(Titl)<64) and (FBuf.VocDum[Test]<>0)) do begin
                  Titl:=Titl+Chr(FBuf.VocDum[Test]);
                  Inc(Test);
                end;
              end;
           6: Rep:=FBuf.VocDum[4]+FBuf.VocDum[5]*256;
           7: Rep:=1;
           8: begin
                NewT:=True;
                SIns:=FBuf.VocDum[7]+1;
                CF  :=SIns;
                Spd2:=(65536-(FBuf.VocDum[4]+Word(FBuf.VocDum[5])*256))*SIns;
                Spd2:=Round(256000000/Spd2);
              end;
           9: begin
                case (FBuf.VocDum[10]+FBuf.VocDum[11]*256) of
                  0 : Fak:=1;
                  1 : Fak:=2;
                  2 : Fak:=3;
                  3 : Fak:=4;
                  4 : Fak:=1;
                512 : Fak:=4;
                end;
                SIns:=FBuf.VocDum[9];
                CF  :=SIns * (FBuf.VocDum[8] div 8);
                Spd :=FBuf.VocDum[4]+Word(FBuf.VocDum[5])*256;
                Len:=Len+Round(100*Fak*Rep*Long3(FBuf.VocLen)/(Spd*CF));
             end;
         end;
         Adr:=Adr+4+Long3(FBuf.VocLen);
         FileSeek(FH,Adr,0);
         Test:=FileRead(FH,FBuf.DummyB,64);
       end;
       Titl:=TitStr(Titl,1);
       SLen:=-Round(Len/10);
       SSam:=Spd;
     end;
end;

{************************************************************************}
{* Routine:     SndInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl fr IFF-8SVX und MAC-FSSs           *}
{* Definition:  Procedure SndInfo;                                      *}
{************************************************************************}

Procedure SndInfo;
Var      IffVar    : IffType;
         Adr,i     : LongInt;
begin
   with InfoRec do begin
     if (FBuf.SVXIff='FORM') then begin
       FTyp:=3;
       Kurz:=FBuf.SvxTyp;    {'8SVX'}
       Lang:='IFF '+FBuf.SvxTyp+'-Sound';
       Titl:='';
       SIns:=1;
       SLen:=0;
       if Kurz='8SVX' then begin
         i:=(SFWord(20)*65536+SFWord(22) + SFWord(24)*65536+SFWord(26));
         SLen:=-Round(i*10.0/SFWord(32));
       end;
       if Kurz='AIFF' then begin
         SIns:=SFWord(20);
         i:=SFWord(22)*65536 + SFWord(24);
         if (FBuf.DummyA[28]=$40) then 
           SLen:=-Round(i*10*(1 shl (14-FBuf.DummyA[29]))/SFWord(30));
       end;
       Adr:=LongI(FBuf.SvxHLe)+$14;
       IffVar.Typ[1]:=' ';
       while ((Adr<256) and (IffVar.Typ<>'BODY')) do begin
         move(FBuf.SvxDum[Adr],IffVar,SizeOf(IffVar));
         if (IffVar.Typ='NAME') then begin
           Titl:=TitStr(IffVar.Par,1);
           Adr:=2000;
         end;
         Adr:=Adr+LongI(IffVar.Len)+8;
       end;
     end
     else if ((FBuf.MacTyp='FSSDJOSH') or (FBuf.MacTyp='FSSDSFX!')) then
       begin
         FTyp:=3;
         Kurz:='MACS';
         Lang:='Macintosh '+FBuf.MacTyp+' Sound';
         Titl:=TitStr(Copy(FBuf.MacTit,1,64),1);
         SIns:=1;
         SLen:=0;
       end;
   end;
end;

{************************************************************************}
{* Routine:     AUInfo                                                  *}
{************************************************************************}
{* Inhalt:      Extraktion von SIns und SLen fr Sun/Next AU-Sound      *}
{* Definition:  Procedure AUInfo;                                       *}
{************************************************************************}

Procedure AUInfo;
Var      i,j       : Longint;
begin
   if (FBuf.DumCh4='.snd') then
     with InfoRec do begin
       FTyp:=3;
       Kurz:='AU  ';
       Lang:='Sun/Next AU-Sound';
       Titl:='';
       SIns:=SFWord(22);
       i:=SFWord(10) + SFWord( 8)*65536;
       j:=SFWord(18) + SFWord(16)*65536;
       SSam := j;
       if SFWord(14)=3 then begin
         j:=j*2;
         Kurz:='AU16';
         Lang:='Sun/Next AU 16bit-Sound';
       end;
       SLen:=-Round(i*10/(j*SIns));
     end;
end;

{************************************************************************}
{* Routine:     MidiInfo                                                *}
{************************************************************************}
{* Inhalt:      Erkennung von Midi-Dateien                              *}
{* Definition:  Procedure MidiInfo;                                     *}
{************************************************************************}

Procedure MidiInfo;
Var      MidVar    : MidType;
         Adr,Adr1  : LongInt;
begin
   if (FBuf.MidKen='MThd') then
     with InfoRec do begin
       FTyp:=3;
       Kurz:='MIDI';
       Lang:='MIDI Song';
       Titl:='';
       SIns:=0;
       Adr:=LongI(FBuf.MidHLe)+8;
       while (Adr<FileSeek(FH,0,2)) do begin
         FileSeek(FH,Adr,0);
         Test:=FileRead(FH,FBuf.DummyP,256);
         Inc(SIns);
         Adr:=Adr+LongI(FBuf.MidHLe)+8;
         if SIns=1 then begin
           Adr1:=8;
           while (Adr1<220) do begin
             move(FBuf.MidDum[Adr1],MidVar,44);
             if ((MidVar.Typ=$03) and (MidVar.Evt=$ff00)) then begin
               if Titl='' then Titl:=TitStr(MidVar.Stg,1);
               if Crea<>'' then Adr1:=2000;
             end;
             if ((MidVar.Typ=$04) and (MidVar.Evt=$ff00)) then begin
               if Crea='' then Crea:=TitStr(MidVar.Stg,1);
               if Titl<>'' then Adr1:=2000;
             end;
             Adr1:=Adr1+MidVar.Len+4;
           end;
         end;
       end;
       SLen:=0;
     end;
end;


