{************************************************************************}
{* Include:     AD_Graph.Inc                                            *}
{************************************************************************}
{* Inhalt:      Graphik-Routinen fr Modul ADInfo.Pas                   *}
{************************************************************************}
{* Version:     1.0.0.6  (AINFO)                                        *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       13.Apr.2003                                             *}
{************************************************************************}

{************************************************************************}
{* Routine:     PcxInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer, GCol und GPac fr ZSoft-PCX  *}
{* Definition:  Procedure PcxInfo;                                      *}
{************************************************************************}

Procedure PcxInfo(Var FBuf:FBufType;FH:Integer;Var InfoRec:DirRec);
Const    PCXVStr   : Array[0..5] of String[10]=
		       ('2.5','x.x','2.8 m.Pal.','2.8 o.Pal.',
			'x.x','3.0 m.Pal.');
begin
   if FBuf.PcxCre=$0a then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='PCX'+ Char(FBuf.PcxVer+$30);
       Lang:='ZSoft Paintbrush PCX Vers. '+PCXVStr[FBuf.PcXVer];
       if FBuf.PcxVer>=5 then begin
	 GHor:=FBuf.PcxXMa-FBuf.PcxXMi+1;
	 GVer:=FBuf.PcxYMa-FBuf.PcxYMi+1;
       end
       else begin
	 GHor:=FBuf.PcxHRe;
	 GVer:=FBuf.PcxVRe;
       end;
       GCol:=1 shl (FBuf.PcxBpP * FBuf.PcxPla);
       if (GCol=0) then GPal:=Longint(1) shl (FBuf.PcxBpP * FBuf.PcxPla)
       else GPal:=0;
       if FBuf.PcxPaI=2 then Comm:='Grey Scaled';
       if FBuf.PcxEnc=1 then Cmpr:='Run Length Encoded';
       GFHo:=FBuf.PcxXMi;
       GFVe:=FBuf.PcxYMi;
     end;
end;

{************************************************************************}
{* Routine:     DcxInfo                                                 *}
{************************************************************************}
{* Inhalt:      berprfung des DCX-Headers und Extraktion der Infos    *}
{* Definition:  Procedure DcxInfo;                                      *}
{************************************************************************}

Procedure DcxInfo(Var FBuf:FBufType;FH:Integer;Var InfoRec:DirRec);
Var      Anz       : Word;
	 Adr       : Longint;
begin
   if (FBuf.DumLIn[0]=987654321) then begin
     Anz:=1;
     while ((FBuf.DumLIn[Anz+1]<>0) and (Anz<63)) do Inc(Anz);
     Adr:=FBuf.DumLin[1];
     FileSeek(FH,Adr,0);
     Test:=FileRead(FH,FBuf.DummyP,256);
     PcxInfo(FBuf,FH,InfoRec);
     with InfoRec do
       if FTyp=1 then begin
	 Kurz[1]:='D';
	 Lang:='CAS/DCX Faximage';
	 GFrm:=Anz;
       end;
   end;
end;

{************************************************************************}
{* Routine:     BmpTest                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer, GCol und GPac fr Win3-BMPs  *}
{*              sowie von GHor, GVer und GCol fr OS/2-BMPs             *}
{* Definition:  Procedure BmpTest;                                      *}
{************************************************************************}

Procedure BmpTest(Var FBuf:FBufType;FH:Integer;Var InfoRec:DirRec);
begin
   with InfoRec do begin
     if FBuf.BmpISi=12 then begin
       Kurz[4]:='O';
       Lang:='OS/2 1.x Bitmap';
       GHor:=FBuf.BmcWid;
       GVer:=FBuf.BmcHei;
       GCol:=Longint(1) shl (FBuf.BmcBit);
     end
     else begin
       if FBuf.BmpISi=40 then begin
	 Kurz[4]:='W';
	 Lang:='Windows Bitmap';
	 GSHo:=Round(Fbuf.BmpXpM/39.37);
	 GSVe:=Round(FBuf.BmpYpM/39.37);
	 EFlg:=2;
       end
       else begin
	 Kurz[4]:='2';
	 Lang:='OS/2 2.x Bitmap';
       end;
       GHor:=FBuf.BmpWid;
       GVer:=FBuf.BmpHei;
       GCol:=Longint(1) shl (FBuf.BmpBit);
       if FBuf.BmpCom>0 then Cmpr:='Run Length Encoded';
     end;
   end;
end;

{************************************************************************}
{* Routine:     BmpInfo                                                 *}
{************************************************************************}
{* Inhalt:      berprfung des Bitmap-Headers und Extraktion der Infos *}
{* Definition:  Procedure BmpInfo;                                      *}
{************************************************************************}

Procedure BmpInfo(Var FBuf:FBufType;FH:Integer;Var InfoRec:DirRec);
begin
   if (FBuf.BmpTyp = $4142) then begin
     FileSeek(FH,14,0);
     Test:=FileRead(FH,FBuf.DummyP,256);
   end;
   if (FBuf.BmpTyp = $4D42) then
     with InfoRec do begin
       FTyp:=1;
       GPal:=0;
       Kurz:='BMP ';
       BmpTest(FBuf,FH,InfoRec);
     end;
end;

{************************************************************************}
{* Routine:     RDIBInfo                                                *}
{************************************************************************}
{* Inhalt:      berprfung des Bitmap-Headers und Extraktion der Infos *}
{* Definition:  Procedure RDIBInfo;                                     *}
{************************************************************************}

Procedure RDibInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
Var      Adr,Len   : LongInt;
	 Len1      : LongInt;
begin
   if (FBuf.RifTag = 'RIFF') and (FBuf.RifTyp = 'RDIB') then begin

{$IFDEF RiffInf}     
     InitRiff;
{$ENDIF}

     Adr:=12;
     Len:=FBuf.RifLen;
     while Adr<Len do begin
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,256);
       Len1:=FBuf.RifLen;
       if (FBuf.RifTag = 'data') then begin
	 FileSeek(FH,Adr+8,0);
	 Test:=FileRead(FH,FBuf.DummyP,256);
	 BmpInfo(FBuf,FH,InfoRec);
	 if InfoRec.Ftyp=1 then begin
	   InfoRec.Kurz:='RDIB';
	   InfoRec.Lang:='RIFF '+InfoRec.Lang;
	 end;
       end;
       if (FBuf.RifTag = 'LIST') and (FBuf.RifTyp = 'INFO') then
	 InfoRiff(Adr,Len1,FBuf,FH,InfoRec);
       Adr:=Adr+Len1+8;
     end;
   end;
end;

{************************************************************************}
{* Routine:     AniInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer u. GCol fr Animierte-Icons   *}
{* Definition:  Procedure AniInfo;                                      *}
{************************************************************************}

Procedure AniInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
Var      Adr,Len   : LongInt;
	 Len1      : LongInt;
begin
   if (FBuf.RifTag='RIFF') and (FBuf.RifTyp='ACON') then
     with InfoRec do begin
       
{$IFDEF RiffInf}
       InitRiff;
{$ENDIF}

       Adr:=12;
       Len:=FBuf.RifLen;
       while Adr<Len do begin
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,128);
	 Len1:=FBuf.RifLen;
	 if (FBuf.RifTag = 'LIST') and (FBuf.RifTyp = 'fram') then begin
	   if (FBuf.RifLst = 'icon') then begin
	     FTyp:=1;
	     Kurz:='ANI ';
	     FileSeek(FH,Adr+20,0);
	     Test:=FileRead(FH,FBuf.DummyP,128);
	     if (FBuf.IcoTyp = 1) then begin
	       Kurz[4]:='I';
	       Lang:='Animiertes Icon';
	     end;
	     if (FBuf.IcoTyp = 2) then begin
	       Kurz[4]:='C';
	       Lang:='Animierter Cursor';
	     end;
	     GHor:=FBuf.IcoSiX;
	     GVer:=FBuf.IcoSiY;
	     GCol:=FBuf.IcoCol;
	     if GCol=0 then GCol:=1 shl FBuf.IcoDum[FBuf.IcoOfs+14];
	   end;
	 end;
	 if (FBuf.RifTag = 'LIST') and (FBuf.RifTyp = 'INFO') then
	   InfoRiff(Adr,Len1,FBuf,FH,InfoRec);
	 Adr:=Adr+Len1+8;
       end;
     end;
end;

{************************************************************************}
{* Routine:     RleInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer, GCol und GPac fr CIS-RLEs   *}
{* Definition:  Procedure RleInfo;                                      *}
{************************************************************************}

Procedure RleInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if ((FBuf.DummyA[0] = $1B) and (FBuf.DummyA[1] = $47)) then
     with InfoRec do begin
       FTyp:=1;
       Cmpr:='Run Length Encoded';
       Kurz:='RLE ';
       Lang:='Compuserve RLE-Bild';
       GCol:=2;
       if FBuf.DummyA[2] = $48 then begin
	 GHor:=256;
	 GVer:=192;
       end
       else begin
	 GHor:=128;
	 GVer:=96;
       end;
     end
   else BmpInfo(FBuf, FH, InfoRec);
end;

{************************************************************************}
{* Routine:     WpgInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol fr WordPerf.-WPGs   *}
{* Definition:  Procedure WpgInfo;                                      *}
{************************************************************************}

Procedure WpgInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
Var      Adr       : Word;
	 Ad1       : Byte;

  Function WpgAdr:LongInt;
  Var    Adr1      : LongInt;
  begin
     Adr1:=FBuf.WpgDum[Adr+$1];
     Ad1:=2;
     if FBuf.WpgDum[Adr+$1]=$ff then begin
       Adr1:=FBuf.WpgDum[Adr+$2]+(FBuf.WpgDum[Adr+3] and $7f)*256;
       Ad1:=4;
       if (FBuf.WpgDum[Adr+$3] and $80)=$80 then begin
	 Adr1:=Adr1*65536+FBuf.WpgDum[Adr+$2]+FBuf.WpgDum[Adr+3]*256;
	 Ad1:=6;
       end;
     end;
     WpgAdr:=Adr+Adr1+Ad1;
  end;

begin
   if (FBuf.WpgHea='WPC') then
     with InfoRec do begin
       Adr:=16;
       while ((Adr<1024) and 
	((FBuf.WpgDum[Adr]<>$0b) and (FBuf.WpgDum[Adr]<>$14))) do begin
	 Adr:=WpgAdr;
	 if Adr>256 then Test:=FileRead(FH,FBuf.DummyB,768);
       end;
       if (Adr<1024) then begin
	 Test:=WpgAdr;
	 FTyp:=1;
	 Kurz:='WPG ';
	 if (FBuf.WpgDum[Adr]=$0b) then begin
	   GHor:=FBuf.WpgDum[Adr+Ad1+$0]+FBuf.WpgDum[Adr+Ad1+$1]*256;
	   GVer:=FBuf.WpgDum[Adr+Ad1+$2]+FBuf.WpgDum[Adr+Ad1+$3]*256;
	   GSHo:=FBuf.WpgDum[Adr+Ad1+$6]+FBuf.WpgDum[Adr+Ad1+$7]*256;
	   GSVe:=FBuf.WpgDum[Adr+Ad1+$8]+FBuf.WpgDum[Adr+Ad1+$9]*256;
	   GCol:=1 shl (FBuf.WpgDum[Adr+Ad1+4]);
	   Lang:='Word Perfect Bitmap Typ I';
	 end;
	 if (FBuf.WpgDum[Adr]=$14) then begin
	   GHor:=FBuf.WpgDum[Adr+Ad1+$0a]+FBuf.WpgDum[Adr+Ad1+$0b]*256;
	   GVer:=FBuf.WpgDum[Adr+Ad1+$0c]+FBuf.WpgDum[Adr+Ad1+$0d]*256;
	   GSHo:=FBuf.WpgDum[Adr+Ad1+$2]+FBuf.WpgDum[Adr+Ad1+$3]*256;
	   GSVe:=FBuf.WpgDum[Adr+Ad1+$4]+FBuf.WpgDum[Adr+Ad1+$5]*256;
	   GFHo:=FBuf.WpgDum[Adr+Ad1+$10]+FBuf.WpgDum[Adr+Ad1+$11]*256;
	   GFVe:=FBuf.WpgDum[Adr+Ad1+$12]+FBuf.WpgDum[Adr+Ad1+$13]*256;
	   GCol:=1 shl (FBuf.WpgDum[Adr+Ad1+$0e]);
	   Lang:='Word Perfect Bitmap Typ II';
	 end;
	 GPal:=0;
	 EFlg:=2;
       end;
     end;
end;

{************************************************************************}
{* Routine:     MspInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol fr MS-MSPs          *}
{* Definition:  Procedure MspInfo;                                      *}
{************************************************************************}

Procedure MspInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if (FBuf.DumCh4='LinS') or (FBuf.DumCh4='DanM') then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='MSP'+Char(FBuf.DummyA[0]);
       Lang:='Microsoft Paint - Typ '+FBuf.DumCh4;
       GHor:=FBuf.DummyA[$4]+FBuf.DummyA[$5]*256;
       GVer:=FBuf.DummyA[$6]+FBuf.DummyA[$7]*256;
       GCol:=1 shl (FBuf.DummyA[$0c]);
     end;
end;

{************************************************************************}
{* Routine:     IcoInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GVor, GVer und GCol fr Win-ICOs und CURs*}
{* Definition:  Procedure IcoInfo;                                      *}
{************************************************************************}

Procedure IcoInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if ((FBuf.IcoKen=0) and (FBuf.IcoTyp<3)) then
     with InfoRec do begin
       FTyp:=1;
       if (FBuf.IcoTyp = 1) then begin
	 Kurz:='ICOW';
	 Lang:='Windows 3.x Icon';
       end;
       if (FBuf.IcoTyp = 2) then begin
	 Kurz:='CURW';
	 Lang:='Windows 3.x Cursor';
       end;
       GHor:=FBuf.IcoSiX;
       GVer:=FBuf.IcoSiY;
       GCol:=FBuf.IcoCol;
     end
   else begin
     if (FBuf.BmpTyp = $4142) then begin
       FileSeek(FH,14,0);
       Test:=FileRead(FH,FBuf.DummyP,256);
     end;
     if ((FBuf.BmpTyp = $4349) or (FBuf.BmpTyp = $4943) or
	 (FBuf.BmpTyp = $5043) or (FBuf.BmpTyp = $5450)) then
       with InfoRec do begin
	 FTyp:=1;
	 GPal:=0;
	 if ((FBuf.BmpTyp = $4349) or (FBuf.BmpTyp = $4943)) then Kurz:='ICO ';
	 if ((FBuf.BmpTyp = $5043) or (FBuf.BmpTyp = $5450)) then Kurz:='CUR ';
	 BmpTest(FBuf,FH,InfoRec);
	 If Kurz='ICOO' then Lang:='OS/2 1.x Icon';
	 If Kurz='ICO2' then Lang:='OS/2 2.x Icon';
	 If Kurz='CURO' then Lang:='OS/2 1.x Cursor';
	 If Kurz='CUR2' then Lang:='OS/2 2.x Cursor';
       end;
   end;
end;

{************************************************************************}
{* Routine:     SciInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol fr ColoRIX-SCx      *}
{* Definition:  Procedure SciInfo;                                      *}
{************************************************************************}

Procedure SciInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if (FBuf.DumCh4='RIX3') then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='CRIX';
       Lang:='ColoRIX/WinRIX Picture';
       GHor:=FWord($4,FBuf);
       GVer:=FWord($6,FBuf);
       GCol:=1;
       if (FBuf.DummyA[$9] and $07)=$04 then GCol:=16;
       if (FBuf.DummyA[$9] and $07)=$00 then GCol:=256;
       if (FBuf.DummyA[$9] and $80)=$80 then Cmpr:='RIX-Compression';
     end;
end;

{************************************************************************}
{* Routine:     FliInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol fr FLIs             *}
{* Definition:  Procedure FliInfo;                                      *}
{************************************************************************}

Procedure FliInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if (FBuf.DummyA[$05]=$AF) then
     with InfoRec do begin
       FTyp:=1;
       if FBuf.DummyA[$04]=$11 then begin
	 Kurz:='AFLI';
	 Lang:='Autodesk Animator FLI';
	 GRat:=Trunc(70/FWord($10,FBuf));
       end
       else begin
	 Kurz:='AFLC';
	 Lang:='Autodesk Animator Pro FLC';
	 GRat:=Trunc(1000/FWord($10,FBuf));
       end;
       GHor:=FWord($08,FBuf);
       GVer:=FWord($0A,FBuf);
       GCol:=1 shl (FBuf.DummyA[$0c]);
       if GCol=1 then GCol:=256;
       GFrm:=FWord($06,FBuf);
     end;
end;

{************************************************************************}
{* Routine:     PicInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GVor, GVer und GCol fr Pictor-PICs      *}
{* Definition:  Procedure PicInfo;                                      *}
{************************************************************************}

Procedure PicInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if (FBuf.DumWrd=$1234) then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='PIC ';
       Lang:='Pictor PIC';
       GHor:=FWord($2,FBuf);
       GVer:=FWord($4,FBuf);
       GCol:=1 shl (FBuf.DummyA[$0a]);
       if GCol=0 then GCol:=16;
     end;
end;

{************************************************************************}
{* Routine:     TgaInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol fr TARGA-TGAs       *}
{* Definition:  Procedure TgaInfo;                                      *}
{************************************************************************}

Procedure TgaInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   with InfoRec do begin
     FTyp:=1;
     Kurz:='TARG';
     Lang:='Targa Picture';
     GHor:=FBuf.TgaWid;
     GVer:=FBuf.TgaHig;
     GFHo:=FBuf.TgaIOX;
     GFVe:=FBuf.TgaIOY;
     GCol:=Longint(1) shl FBuf.TgaPix;
     if FBuf.TgaMTy<>0 then GPal:=Longint(1) shl FBuf.TgaCMS;
     if (FBuf.TgaTyp>=8) and (FBuf.TgaTyp<=11) then
       Cmpr:='Run Length Encoded';
     if (FBuf.TgaTyp>=32) and (FBuf.TgaTyp<=33) then
       Cmpr:='Huffman + Delta Encoded';
   end;
end;

{************************************************************************}
{* Routine:     RasInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol fr Sun-RASs         *}
{* Definition:  Procedure RasInfo;                                      *}
{************************************************************************}

Procedure RasInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   with InfoRec do begin
     FTyp:=1;
     Kurz:='RAS ';
     Lang:='SUN Rasterfile';
     GHor:=SFWord($06,FBuf);
     GVer:=SFWord($0a,FBuf);
     GCol:=1 shl (FBuf.DummyA[$0f]);
   end;
end;

{************************************************************************}
{* Routine:     TiffInfo                                                *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer, GCol und GPac fr TIFFs (I+M)*}
{* Definition:  Procedure TiffInfo;                                     *}
{************************************************************************}

Procedure TiffInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
Var      i,j,Maxi  : Integer;
	 Fakt      : Real;
	 HF        : TBufType;
	 Mot       : Boolean;
	 Adr       : Longint;

  Function TiffCopy(Ind:Word):LongInt;
  begin
    case(FBuf.TifTag[i].Typ) of
      $003: TiffCopy:=HF.WW[Ind];
      $004: TiffCopy:=HF.IW[Ind];
      $005: TiffCopy:=Round(HF.IW[Ind*2]/HF.IW[(Ind*2)+1]);
      $300: TiffCopy:=Swap(HF.WW[Ind]);
      $400: TiffCopy:=LongI(HF.MW[Ind]);
      $500: TiffCopy:=Round(LongI(HF.MW[Ind*2])/LongI(HF.MW[(Ind*2)+1]));
      else  TiffCopy:=HF.BW[Ind];
    end;
  end;

  Function TiffStr:String;
  Var    HStr      : String;
	 k         : Byte;
  begin
    k:=0;
    while ((k<64) and (HF.CW[k]<>#0)) do begin
      HStr:=HStr+HF.CW[k];
      inc(k,1);
    end;
    TiffStr:=HStr;
  end;

  Procedure TiffRead;
  Var    ERead     : Boolean;
  begin
    ERead:=False;
    fillchar(HF,100,#0);
    with FBuf.TifTag[i] do begin
      if Mot then begin
	ICnt:=LongI(MCnt);
	Tag:=Swap(Tag);
      end;
      case (Typ) of
	$1,$100: if ICnt>4 then ERead:=True;
	$2,$200: if ICnt>4 then ERead:=True;
	$3,$300: if ICnt>2 then ERead:=True;
	$4,$400: if ICnt>1 then ERead:=True;
	$5,$500: ERead:=True;
      end;
      if (ERead) then begin
	if Mot then Adr:=LongI(MOfs)
	else Adr:=IOfs;
	FileSeek(FH,Adr,0);
	Test:=FileRead(FH,HF.CW,100);
      end
      else HF.IW[0]:=IOfs;
    end;
  end;

begin
   if (FBuf.DummyA[0]=$4D) or (FBuf.DummyA[0]=$49) then
     with InfoRec do begin
       Mot:=False;
       FTyp:=1;
       Kurz:='TIFF';
       Lang:='TIFF Bild (Intel Format)';
       Fakt:=1;
       if (FBuf.DummyA[0]=$4D) then begin
	 Mot:=True;
	 Kurz[4]:='M';
	 Lang:='TIFF Bild (Motorola Format)';
	 Adr:=SFWord($06,FBuf);
	 Adr:=Adr+FBuf.DummyA[$05]*65536;
       end
       else begin
	 Adr:=FWord($04,FBuf);
	 Adr:=Adr+FBuf.DummyA[$06]*65536;
       end;
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,1024);
       GPal:=0;
       if Mot then Maxi:=Swap(FBuf.TifCnt)
       else Maxi:=FBuf.TifCnt;
       for i:=1 to Maxi do begin
	 TiffRead;
	 case FBuf.TifTag[i].Tag of
	   $0100: GHor:=TiffCopy(0);
	   $0101: GVer:=TiffCopy(0);
	   $0102: begin
		    for j:=1 to FBuf.TifTag[i].ICnt do
		      GCol:=GCol+TiffCopy(j-1);
		    GCol:=Longint(1) shl GCol;
		  end;
	   $0103: case TiffCopy(0) of
		    1: Cmpr:='Packed Bits';
		    2: Cmpr:='1D CCITT (Huffmann)';
		    3: Cmpr:='CCITT Fax 3';
		    4: Cmpr:='CCITT Fax 4';
		    5: Cmpr:='Lempl-Zip-Welch';
		    6: Cmpr:='Discrete-Cosinus-Transf.';
		  end;
	   $011A: GSHo:=TiffCopy(0);
	   $011B: GSVe:=TiffCopy(0);
	   $0128: case TiffCopy(0) of
		    1: Fakt:=0;
		    2: Fakt:=1;
		    3: Fakt:=2.54;
		  end;
	 end;
       end;
       if Fakt<>0 then begin
	 GSHo:=Round(Fakt*GSHo);
	 GSVe:=Round(Fakt*GSVe);
	 EFlg:=2;
       end;
     end;
end;

{************************************************************************}
{* Routine:     CutInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor und GVer fr Dr.Halo-CUTs           *}
{* Definition:  Procedure CutInfo;                                      *}
{************************************************************************}

Procedure CutInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   with InfoRec do begin
     FTyp:=1;
     Kurz:='CUT ';
     Lang:='Dr.Halo / Dr.Genius CUT';
     GHor:=FWord($00,FBuf);
     GVer:=FWord($02,FBuf);
     GCol:=1;
   end;
end;

{************************************************************************}
{* Routine:     JpgInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol fr JPEG-JPGs        *}
{* Definition:  Procedure JpgInfo;                                      *}
{************************************************************************}

Procedure JpgInfo(Var FBuf:FBufType;FH:Integer;Var InfoRec:DirRec);
Var      Adr       : Word;
begin
   with InfoRec do begin
     FTyp:=1;
     Test:=FileRead(FH,FBuf.DummyB,768);
     if ((FBuf.DummyA[0]=$68) and (FBuf.DummyA[1]=$73)) then begin
       Adr:=2+SFWord(14,FBuf);
       Kurz:='HSIJ';
       Lang:='HSI-JPEG Picture';
     end
     else begin
       Adr:=2;
       Kurz:='JPEG';
       Lang:='JPEG Picture';
     end;
     while ((Adr<1024) and
	    (FBuf.DummyA[Adr+1]<>$c0) and
	    (FBuf.DummyA[Adr+1]<>$c2)) do begin
       if FBuf.DummyA[Adr+1]=$e0 then begin
	 if CFCompare(Addr(FBuf.DummyA[Adr+4]),'JFIF') then begin
	   GSHo:=SFWord(Adr+10,FBuf);
	   GSVe:=SFWord(Adr+12,FBuf);
	   case FBuf.DummyA[Adr+9] of
	     0: EFlg:=0;
	     1: EFlg:=2;
	     2: begin
		  EFlg:=2;
		  GSHo:=Round(GSHo*2.54);
		  GSVe:=Round(GSHo*2.54);
		end;
	   end;
	   if Kurz='JPEG' then Lang:='JFIF-JPEG Picture';
	 end;
       end;
       Adr:=Adr+2+SFWord(Adr+2,FBuf);
     end;
     if Adr<1024 then begin
       GHor:=SFWord(Adr+7,FBuf);
       GVer:=SFWord(Adr+5,FBuf);
       GCol:=Longint(1) shl (FBuf.DummyA[Adr+4]*FBuf.DummyA[Adr+9]);
       if FBuf.DummyA[Adr+9]=1 then Comm:='Grey Scaled';
     end
     else begin
       GHor:=0;
       GVer:=0;
       GCol:=1;
     end;
     Cmpr:='Discrete Cosinus Transf.';
   end;
end;

{************************************************************************}
{* Routine:     GifInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer, GCol, GPal und GPac fr      *}
{*              Compuserve-GIFs                                         *}
{* Definition:  Procedure GifInfo;                                      *}
{************************************************************************}

Procedure GifInfo(Var FBuf:FBufType;FH:Integer;Var InfoRec:DirRec);
begin
   if (FBuf.GifSIG = 'GIF') then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='G'+FBuf.GifVer;
       Lang:='CompuServe GIF '+FBuf.GifVer;
       GHor:=FBuf.GifLSW;
       GVer:=FBuf.GifLSH;
       GCol:=1 shl ((FBuf.GifPF1 mod 8)+1);
       GPal:=Longint(1) shl ((((FBuf.GifPF1 div 16) mod 8)+1)*3);
       Cmpr:='Lempl-Zip-Welch';
     end;
end;

{************************************************************************}
{* Routine:     LbmInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer, GCol und GPac fr IFF-ILBMs  *}
{* Definition:  Procedure LbmInfo;                                      *}
{************************************************************************}

Procedure LbmInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if ((FBuf.LbmIff ='FORM') and
       ((FBuf.LbmTyp ='ILBM') or (FBuf.LbmTyp = 'PBM '))) then
     with InfoRec do begin
       FTyp:=1;
       Kurz:=FBuf.LbmTyp;
       Lang:='IFF '+FBuf.LbmTyp+'-Picture';
       GHor:=Swap(FBuf.LbmBmX);
       GVer:=Swap(FBuf.LbmBmY);
       GCol:=1 shl (FBuf.LbmBPl);
       GSHo:=FBuf.LbmAsX;
       GSVe:=FBuf.LbmAsY;
       GFHo:=FBuf.LbmXPo;
       GFVe:=FBuf.LbmYPo;
       if FBuf.LbmPac=1 then Cmpr:='Run Length Encoding';
     end;
end;

{************************************************************************}
{* Routine:     ImgInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol von GEM-IMGs         *}
{* Definition:  Procedure ImgInfo;                                      *}
{************************************************************************}

Procedure ImgInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   with InfoRec do begin
     FTyp:=1;
     Kurz:='GEM ';
     Lang:='GEM Image';
     GHor:=Swap(FBuf.GemPiZ);
     GVer:=Swap(FBuf.GemEle);
     GSHo:=Swap(FBuf.GemSiX);
     GSVe:=Swap(FBuf.GemSiY);
     EFlg:=1;
     GCol:=1 shl (Swap(FBuf.GemBpP));
   end;
end;

{************************************************************************}
{* Routine:     MacInfo                                                 *}
{************************************************************************}
{* Inhalt:      Identifikation von MAC-PNT und Setzen von GHor, GVer    *}
{*              und GCol                                                *}
{* Definition:  Procedure MacInfo;                                      *}
{************************************************************************}

Procedure MacInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if (FBuf.MacTyp='PNTGMPNT') then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='MAC ';
       Lang:='Mactintosh '+FBuf.MacTyp+' Picture';
       GHor:=576;
       GVer:=720;
       GCol:=2;
     end;
end;

{************************************************************************}
{* Routine:     AviInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer fr AVIs                      *}
{* Definition:  Procedure AviInfo;                                      *}
{************************************************************************}

Procedure AviInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
begin
   if ((FBuf.AviIff='RIFF') and (FBuf.AviTyp='AVI ')) then
     with InfoRec do begin
{      InitRiff; }
       FTyp:=1;
       Kurz:='AVI ';
       Lang:='Audio-Visuelle Ressource';
       if (FBuf.AviSub='vids') then begin
	 Cmpr:=FBuf.AviCod+'-Codec ?';
	 if (FBuf.AviCod='ULTI') then begin
	   Kurz[4]:='U';
	   Cmpr:='IBM Ultimedia codec';
	 end;
	 if (FBuf.AviCod='msvc') then begin
	   Kurz[4]:='M';
	   Cmpr:='MS Video 1 codec';
	 end;
	 if (FBuf.AviCod='MRLE') then begin
	   Kurz[4]:='M';
	   Cmpr:='MS Run-Length codec';
	 end;
	 if (FBuf.AviCod='RT21') then begin
	   Kurz[4]:='I';
	   Cmpr:='Intel Indeo 2.x codec';
	 end;
	 if (FBuf.AviCod='IV31') then begin
	   Kurz[4]:='I';
	   Cmpr:='Intel Indeo 3.x codec';
	 end;
	 if (FBuf.AviCod='CVID') then begin
	   Kurz[4]:='C';
	   Cmpr:='Cinpak 1.5 codec';
	 end;
       end;
       GHor:=FBuf.AviHor;
       GVer:=FBuf.AviVer;
       GCol:=1;
     end;
end;

{************************************************************************}
{* Routine:     MovInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer fr QuickTime-MOVies          *}
{* Definition:  Procedure MovInfo;                                      *}
{************************************************************************}

Procedure MovInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
Var      Adr       : Longint;
begin
   if ((FBuf.MovTag='mdat') or (FBuf.MovTag='moov')) then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='QTM ';
       Lang:='Quick-Time Movie';
       GHor:=0;
       GVer:=0;
       GCol:=0;
       Adr:=0;
       if (FBuf.MovTag='mdat') then begin
	 Adr:=LongI(FBuf.MovLen);
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.Dummy0,64);
       end;
       if (FBuf.MovTag='moov') and (FBuf.MovHTg='mvhd') then begin
	 Adr:=Adr+8+LongI(FBuf.MovLe1);
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.Dummy0,256);
	 if (FBuf.MovTag='trak') and (FBuf.MovHTg='tkhd') then begin
	   GHor:=SFWord(92,FBuf);
	   GVer:=SFWord(96,FBuf);
	 end;
       end;
       if (FBuf.MovTag='moov') and (FBuf.MovHTg='cmov') then begin
	 Comm:='Kompr. Mov-Datei';
       end;
     end;
end;

{************************************************************************}
{* Routine:     PngInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von GHor, GVer und GCol von PNGs             *}
{* Definition:  Procedure PngInfo;                                      *}
{************************************************************************}

Procedure PngInfo(Var FBuf:FBufType; FH:Integer; Var InfoRec:DirRec);
Const    PngId     : Array [1..8] of Byte = (137,80,78,71,13,10,26,10);
begin
   if BFCompare(Addr(FBuf.PngHea),Addr(PngId),7) then
     with InfoRec do begin
       FTyp:=1;
       Kurz:='PNG ';
       Lang:='Portable Network Graphic';
       GHor:=LongI(FBuf.PngSiX);
       GVer:=LongI(FBuf.PngSiY);
       GPal:=0;
       case (FBuf.PngPTy) of
	 0 : begin
	       GCol:=1 shl FBuf.PngBpP;
	       Comm:='Grey Scaled';
	     end;
	 2 : begin
	       GCol:=1 shl (FBuf.PngBpP*3);
	     end;
	 3 : begin
	       GCol:=1 shl FBuf.PngBpP;
	       GPal:=1 shl 24;
	     end;
	 4 : begin
	       GCol:=1 shl FBuf.PngBpP;
	       Comm:='Grey Scaled';
	     end;
	 6 : begin
	       GCol:=1 shl (FBuf.PngBpP*3);
	     end;
       end;
       Cmpr:='LZ-77';
     end;
end;


