{************************************************************************}
{* Include:     AD_Archv.Inc                                            *}
{************************************************************************}
{* Inhalt:      Archiv-Routinen fr Modul ADInfo.Pas                    *}
{************************************************************************}
{* Version:     0.52a   (AINFO)                                         *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       05.Apr.1994                                             *}
{************************************************************************}

{************************************************************************}
{* Routine:     ArjInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr ARJs                   *}
{* Definition:  Procedure ArjInfo;                                      *}
{************************************************************************}

Procedure ArjInfo;
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,XSi   : Word;
begin
   if (FBuf.ArjKen=$EA60) then
     with InfoRec do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       while (FBuf.ArjHSi <> 0) do begin
	 if FBuf.ArjHSi>244 then
	   Test:=FileRead(FH,FBuf.DummyB,FBuf.ArjHSi-240);
	 if FBuf.ArjTyp = 2 then Adr:=Adr+FBuf.ArjHSi+10
	 else Adr:=Adr+FBuf.ArjHSi+10+FBuf.ArjCSi;
	 XSi:=FBuf.ArjHSi+8;
	 XSi:=FBuf.ArjDum[XSi]+FBuf.ArjDum[XSi+1]*256;
	 if XSi<>0 then Adr:=Adr+XSi+4;
	 if FBuf.ArjTyp < 2 then begin
	   GeSi:=GeSi+FBuf.ArjUSi;
	   CoSi:=CoSi+FBuf.ArjCSi;
	   Inc(Anz);
	 end;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,256);
       end;
       FTyp:=6;
       Kurz:='ARJ ';
       Lang:='ARJ-Archiv';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
     end;
end;

{************************************************************************}
{* Routine:     ArcInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr ARCs und PAKs          *}
{* Definition:  Procedure ArcInfo;                                      *}
{************************************************************************}

Procedure ArcInfo;
Const    MetStr    : Array[0..11] of TString=
		     ('EOF-Tag   ','Stored old','Stored    ','Packed    ',
		      'Squeezed  ','crunched o','crunched  ','crunched S',
		      'Crunched  ','Squashed  ','Crushed   ','Distilled ');
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,Met   : Word;

begin
   if (FBuf.ArcKen=$1a) then
     with InfoRec do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       Met:=0;
       while ((FBuf.ArcKen=$1a) and (FBuf.ArcTyp<>0)) do begin
	 Adr:=Adr+FBuf.ArcCSi+29;
	 GeSi:=GeSi+FBuf.ArcUSi;
	 CoSi:=CoSi+FBuf.ArcCSi;
	 Inc(Anz);
	 if Met < FBuf.ArcTyp then Met:=FBuf.ArcTyp;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,64);
       end;
       FTyp:=6;
       if FBuf.ArcTyp <> 11 then begin
	 Kurz:='ARC ';
	 Lang:='Sea- oder PK-ARC Archiv';
       end
       else begin
	 Kurz:='PAK ';
	 Lang:='NoGate- oder PK-PAK Archiv';
       end;
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       Cmpr:=MetStr[Met];
     end;
end;

{************************************************************************}
{* Routine:     ZipInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr ZIPs                   *}
{* Definition:  Procedure ZipInfo;                                      *}
{************************************************************************}

Procedure ZipInfo;
Const    MetStr    : Array[0..11] of TString=
		     ('Stored    ','Shrinked  ','Reduced 1x','Reduced 2x',
		      'Reduced 3x','Reduced 4x','Imploded  ','Token     ',
		      'Deflated  ','Method 09 ','Method 10 ','Method 11 ');
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,Met   : Word;

begin
   if ((FBuf.ZipKen=$4b50) and (FBuf.ZipTyp=$0403)) then
     with InfoRec do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       Met:=0;
       while (FBuf.ZipTyp=$0403) do begin
	 Adr:=Adr+FBuf.ZilCSi+FBuf.ZilNSi+FBuf.ZilESi+30;
	 GeSi:=GeSi+FBuf.ZilUSi;
	 CoSi:=CoSi+FBuf.ZilCSi;
	 Inc(Anz);
	 if Met < FBuf.ZilMet then Met:=FBuf.ZilMet;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,256);
       end;
       FTyp:=6;
       Kurz:='ZIP ';
       Lang:='PK-ZIP Archiv';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       Cmpr:=MetStr[Met];
     end;
end;

{************************************************************************}
{* Routine:     LzhInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr LZHs und ICEs          *}
{* Definition:  Procedure LzhInfo;                                      *}
{************************************************************************}

Procedure LzhInfo;
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz       : Word;
begin
   if ((FBuf.LzhMet[1]='l') and (FBuf.LzhMet[2]='h')) then
     with InfoRec do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       while (FBuf.LzhHSi <> 0) do begin
	 Adr:=Adr+FBuf.LzhHSi+2+FBuf.LzhCSi;
	 GeSi:=GeSi+FBuf.LzhUSi;
	 CoSi:=CoSi+FBuf.LzhCSi;
	 Inc(Anz);
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,256);
       end;
       FTyp:=6;
       Kurz:='LZH ';
       Lang:='LZH Archiv';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
     end;
end;

{************************************************************************}
{* Routine:     ZooInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr ZOOs                   *}
{* Definition:  Procedure ZooInfo;                                      *}
{************************************************************************}

Procedure ZooInfo;
Const    MetStr    : Array[0..3] of TString=
		     ('Stored    ','ZOO Normal','ZOO High  ','Reserved  ');
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,Met   : Word;
begin
   if ((FBuf.ZooRe1[0]='Z') and (FBuf.ZooRe1[1]='O')) then
     with InfoRec do begin
       Adr:=FBuf.DummyA[$18];
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,256);
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       Met:=0;
       while ((FBuf.ZooKe1 <> 0) or (FBuf.ZooUSi <> 0)) do begin
	 Adr:=FBuf.ZooOfs;
	 GeSi:=GeSi+FBuf.ZooUSi;
	 CoSi:=CoSi+FBuf.ZooCSi;
	 Inc(Anz);
	 if Met < FBuf.ZooKe1 then Met:=FBuf.ZooKe1;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,256);
       end;
       FTyp:=6;
       Kurz:='ZOO ';
       Lang:='ZOO Archiv';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       Cmpr:=MetStr[Met];
     end;
end;

{************************************************************************}
{* Routine:     SqzInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr SQZs                   *}
{* Definition:  Procedure SqzInfo;                                      *}
{************************************************************************}

Procedure SqzInfo;
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz       : Word;
begin
   if ((FBuf.DummyA[0]=$48) and (FBuf.DummyA[1]=$4C)) then
     with InfoRec do begin
       Adr:=8;
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,64);
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       if (FBuf.SqzTyp = 1) then begin
	 Adr:=Adr+FBuf.SqzCCS+10;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,64);
       end;
       while (FBuf.SqzTyp <> 0) do begin
	 if (FBuf.SqzTyp < 18) then 
	   if (FBuf.SqzTyp = 1) then Adr:=Adr+FBuf.SqzCCS+10
	   else Adr:=Adr+Fbuf.SqzCUS+3
	 else begin
	   Adr:=Adr+FBuf.SqzCSi+FBuf.SqzTyp+2;
	   GeSi:=GeSi+FBuf.SqzUSi;
	   CoSi:=CoSi+FBuf.SqzCSi;
	   Inc(Anz);
	 end;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,64);
       end;
       FTyp:=6;
       Kurz:='SQZ ';
       Lang:='SQZ Archiv';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       Cmpr:='';
     end;
end;

{************************************************************************}
{* Routine:     RarInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr RARs                   *}
{* Definition:  Procedure RarInfo;                                      *}
{************************************************************************}

Procedure RarInfo;
Var      GeSi,CoSi : Longint;
	 Adr,Len   : Longint;
	 Anz       : Word;
begin
   if (SFWord(0)=$5245) then
     with InfoRec do begin
       Adr:=FBuf.RarHLe;
       Len:=FileSeek(FH,0,2);
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,64);
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       while (Adr<Len) do begin
	 Adr:=Adr+FBuf.RarCSi+FBuf.RarFLe;
	   if not((FBuf.RarAtt and $18)>0) then begin
	   GeSi:=GeSi+FBuf.RarUSi;
	   CoSi:=CoSi+FBuf.RarCSi;
	   Inc(Anz);
	 end;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,64);
       end;
       FTyp:=6;
       Kurz:='RAR ';
       Lang:='RAR Archiv (altes Format)';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       Cmpr:='';
     end
   else if (SFWord(0)=$5261) then
     with InfoRec do begin
       Adr:=FBuf.RanHLe;
       Len:=FileSeek(FH,0,2);
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,64);
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       while (Adr<Len) do begin
	 Adr:=Adr+FBuf.RanHLe;
	 if (FBuf.RanFlg and $8000)=$8000 then Adr:=Adr+FBuf.RanCSi;
	 if (FBuf.RanTyp = $74) then begin
	   GeSi:=GeSi+FBuf.RanUSi;
	   CoSi:=CoSi+FBuf.RanCSi;
	   Inc(Anz);
	 end;
	 FileSeek(FH,Adr,0);
	 Test:=FileRead(FH,FBuf.DummyP,64);
       end;
       FTyp:=6;
       Kurz:='RARn';
       Lang:='RAR Archiv (neues Format)';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       Cmpr:='';
     end
end;

{************************************************************************}
{* Routine:     Gl1Info                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von PFil und PPro fr Grasp-GLs              *}
{* Definition:  Procedure Gl1Info;                                      *}
{************************************************************************}

Procedure Gl1Info;
begin
   if (FBuf.Gl1HSi mod 17)=0 then
     with InfoRec do begin
       FTyp:=6;
       Kurz:='GL  ';
       PFil:=(FBuf.Gl1HSi div 17) - 1;
       PPro:=0;
       Cmpr:='Stored    ';
     end;
end;



