{************************************************************************}
{* Include:     AD_Appli.Inc                                            *}
{************************************************************************}
{* Inhalt:      Applikations-Routinen fr Modul ADInfo.Pas              *}
{************************************************************************}
{* Version:     1.0.0.2  (AINFO)                                        *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       23.Jun.2000                                             *}
{************************************************************************}

{************************************************************************}
{* Routine:     DevTest                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion der Device-Bezeichnungen aus einem Device-   *}
{*              Treiber                                                 *}
{* Definition:  Function DevTest(Adr1:Longint):String                   *}
{************************************************************************}

Function DevTest(Adr1:Longint):String;
Var      Adr       : Longint;
         HStr      : String;
         TOfs      : Word;
begin
   HStr:='';
   Adr:=Adr1;
   TOfs:=0;
   FileSeek(FH,Adr,0);
   Test:=FileRead(FH,FBuf.DummyP,64);
   Adr:=Adr1+FBuf.DevLOf;
   while((FBuf.DevLOf<>$ffff) and (Adr < FileSeek(FH,0,2)) and 
         ((FBuf.DevLSe=$0000) or (FBuf.DevLSe>=FBuf.DevLOf)) and
         (TOfs+16 < FBuf.DevLOf)) do begin
     TOfs:=FBuf.DevLOf;
     if (FBuf.DevAtt and $8000)=$8000 then HStr:=HStr+FBuf.DevNam+'|'
     else HStr:=HStr+Format('%.*d',[2,Ord(FBuf.DevNam[1])])+' Laufw|';
     FileSeek(FH,Adr,0);
     Test:=FileRead(FH,FBuf.DummyP,32);
     Adr:=Adr1+FBuf.DevLOf;
   end;
   if ((FBuf.DevLOf=$ffff) and (FBuf.DevLSe=$ffff)) then begin
     if (FBuf.DevAtt and $8000)=$8000 then HStr:=HStr+FBuf.DevNam+'|'
     else HStr:=HStr+Format('%.*d',[2,Ord(FBuf.DevNam[1])])+' Laufw|';
     DevTest:=HStr;
   end
   else DevTest:='';
end;

{************************************************************************}
{* Routine:     SearchCoffVers                                          *}
{************************************************************************}
{* Inhalt:      Suche des Applikationsnamens aus der Versiononsinfo     *}
{*              fr Win32-EXE-Dateien                                   *}
{* Definition:  Function SearchCoffVers(Var Adr:Longint):String         *}
{************************************************************************}

Function SearchCoffVers(Var Adr:Longint):String;
Const    CStr1     : Array[0..4] of Byte = ($34,$00,$00,$00,$56);
         CStr2     : Array[0..11] of Byte
                       = ($46,$00,$69,$00,$6c,$00,$65,$00,$44,$00,$65,$00);
Var      i,j,l     : Integer;
         HStr      : String;
begin
   HStr:='';
   for i:=0 to 1000 do
     if BFCompare (Addr(FBuf.DummyA[i]),Addr(CStr1),4) then begin
       for j:=i to 1400 do
         if BFCompare (Addr(FBuf.DummyA[j]),Addr(CStr2),11) then begin
           for l:=0 to 31 do
             HStr:= HStr + Char(FBuf.DummyA[j+2*l+34]);
           break;
         end;
       break;
     end;
   SearchCoffVers:=HStr;
end;

{************************************************************************}
{* Routine:     ExeInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Betriebsysten, Titl, EFlg und EVer fr   *}
{*              DOS-, WIN und OS/2-EXE-Dateien (incl. Treiber+DLLs)     *}
{* Definition:  Procedure ExeInfo;                                      *}
{************************************************************************}

Procedure ExeInfo;
Var      HStr      : String;
         i,j       : Byte;
         Adr       : Longint;
begin
   if (FBuf.ExeKen = $5A4D) then
     with InfoRec do begin
       FTyp:=2;
       Kurz:='DOS ';
       Lang:='DOS EXE-Programm';
       Titl:='';
       EFlg:=0;
       EVer:=0;

       if (FBuf.ExeSRe = 64) then begin
         Adr:=FBuf.ExeAdN;
         FileSeek(FH,FBuf.ExeAdN,0);
         Test:=FileRead(FH,FBuf.DummyP,172);
         if (FBuf.ExnKen=$454E) then begin
           if (FBuf.ExnFl2 = 2) then begin
             Kurz:='WIN ';
             if (FBuf.ExnFl1 and $8000)=$8000 then
               Lang:='Windows Bibliothek'
             else Lang:='Windows Applikation';
             EVer:=FBuf.ExnVer;
           end
           else if (FBuf.ExnFl2 = 1) then
             if (FBuf.ExnFl1 and $0800)=$0800 then begin
               Kurz:='FAPI';
               Lang:='OS/2 FAPI Applikation';
             end
             else if (FBuf.ExnFl1 and $0300)=$0300 then begin
               Kurz:='PM/2';
               if (FBuf.ExnFl1 and $8000)=$8000 then
                 Lang:='OS/2 PM Bibliothek'
               else Lang:='OS/2 PM Applikation';
             end
             else begin
               Kurz:='OS/2';
               if (FBuf.ExnFl1 and $8000)=$8000 then
                 Lang:='OS/2 Treiber/Bibliothek'
               else Lang:='OS/2 Kommandozeilen Programm';
             end
           else if (FBuf.ExnFl2 = 5) then begin
             Kurz:='BOSS';
             Lang:='Borland prot. Mode Programm';
           end
           else begin
             Kurz[4]:='?';
             Lang:='Programm von unbek. Betriebssystem'
           end;
           if (FBuf.ExnFl1 and $0010)=$0010 then Comm:='Braucht Intel 8086';
           if (FBuf.ExnFl1 and $0020)=$0020 then Comm:='Braucht Intel 80286';
           if (FBuf.ExnFl1 and $0040)=$0040 then Comm:='Braucht Intel 80386';
           if (FBuf.ExnFl1 and $0080)=$0080 then 
             If Comm <> '' then Comm:=Comm+' + FPU'
             else Comm:='Braucht Numerik Prozessor';
           EFlg:=FBuf.ExnFl3;
           FileSeek(FH,FBuf.ExnONN,0);
           Test:=FileRead(FH,FBuf.DummyP,256);
           HStr:=FBuf.DumStr;
           if (Pos('Microsoft',HStr)<>0) and (Length(HStr)>64) then begin
             Test:=Pos('Microsoft',HStr);
             HStr:=Copy(HStr,1,Test-1) + 'MS' +
                   Copy(HStr,Test+9,Length(HStr)-Test-8);
           end;
           if (Pos('FONTRES',HStr)<>0) and (Length(HStr)>64) then begin
             Test:=Pos(':',HStr);
             HStr:='FNT:' + Copy(HStr,Test+1,Length(HStr)-Test);
           end;
           Titl:=Copy(HStr,1,64);
         end
         else if (FBuf.ExnKen=$454C) then begin
           case FBuf.ExlCPU of
             $01: Comm:='Braucht Intel 80286 oder hher';
             $02: Comm:='Braucht Intel 80386 oder hher';
             $03: Comm:='Braucht Intel 80486 oder hher';
             $04: Comm:='Braucht Intel Pentium oder hher';
             $20: Comm:='Braucht Intel i860 (N10)';
             $21: Comm:='Braucht Intel "N11"';
             $40: Comm:='Braucht MIPS Mark I (R2000, R3000)';
             $41: Comm:='Braucht MIPS Mark II (R6000)';
             $42: Comm:='Braucht MIPS Mark III (R4000)';
           end;
           FileSeek(FH,FBuf.ExlONN,0);
           Test:=FileRead(FH,FBuf.DummyP,256);
           Kurz:='W386';
           Lang:='Win386 Applikation/Treiber';
           HStr:=FBuf.DumStr;
           EVer:=FBuf.ExlVer;
           if (Pos('Microsoft',HStr)<>0) and (Length(HStr)>64) then begin
             Test:=Pos('Microsoft',HStr);
             HStr:=Copy(HStr,1,Test-1) + 'MS' +
                   Copy(HStr,Test+9,Length(HStr)-Test-8);
           end;
           Titl:=Copy(HStr,1,64);
         end
         else if (FBuf.ExnKen=$584C) then begin
           if (FBuf.ExlMoT and $0300)=$0300 then begin
             Kurz:='PM2L';
             if (FBuf.ExlMot and $8000)=$8000 then
               Lang:='32bit OS/2 PM-Bibliothek'
             else Lang:='32bit OS/2 PM-Applikation';
           end
           else begin
             Kurz:='OS2L';
             if (FBuf.ExlMot and $8000)=$8000 then
               Lang:='32bit OS/2 Treiber/Bibliothek'
             else Lang:='32bit OS/2 Kommandoz. Programm';
           end;
           case FBuf.ExlCPU of
             $01: Comm:='Braucht Intel 80286 oder hher';
             $02: Comm:='Braucht Intel 80386 oder hher';
             $03: Comm:='Braucht Intel 80486 oder hher';
             $04: Comm:='Braucht Intel Pentium oder hher';
             $20: Comm:='Braucht Intel i860 (N10)';
             $21: Comm:='Braucht Intel "N11"';
             $40: Comm:='Braucht MIPS Mark I (R2000, R3000)';
             $41: Comm:='Braucht MIPS Mark II (R6000)';
             $42: Comm:='Braucht MIPS Mark III (R4000)';
           end;
           if FBuf.ExlONN<>0 then begin
             FileSeek(FH,FBuf.ExlONN,0);
             Test:=FileRead(FH,FBuf.DummyP,256);
             HStr:=FBuf.DumStr;
             if (Pos('Presentation Manager',HStr)<>0) and
                (Length(HStr)>64) then begin
               Test:=Pos('Presentation Manager',HStr);
               HStr:=Copy(HStr,1,Test-1) + 'PM' +
                     Copy(HStr,Test+20,Length(HStr)-Test-19);
             end;
             if (Pos('Application',HStr)<>0) and 
                (Length(HStr)>64) then begin
               Test:=Pos('Application',HStr);
               HStr:=Copy(HStr,1,Test-1) + 'App.' +
                     Copy(HStr,Test+11,Length(HStr)-Test-10);
             end;
             Titl:=Copy(HStr,1,64);
           end;
         end
         else if (FBuf.ExnKen=$4550) then begin
           Kurz:='COFF';
           Lang:='Windows-NT Modul im COFF-Format';
           j:=FBuf.CofAnz;
           FileSeek(FH,Adr+FBuf.CofOfs+24,0);
           Test:=FileRead(FH,FBuf.DummyB,512);
           for i:=1 to j do begin
             if CFCompare (Addr(FBuf.CofEnt [i]),'.rsrc') then begin
               Adr:=FBuf.CofEnt[i].Pos;
               FileSeek(FH,Adr,0);
               Test:=FileRead(FH,FBuf.DummyP,1536);
               Titl:=SearchCoffVers(Adr);
               break;
             end;
           end;
         end
       end
       else begin
         HStr:=Copy(DevTest(FBuf.ExeGHe*16),1,64);
         if HStr<>'' then begin
           Kurz:='DDEV';
           Lang:='DOS Device Treiber';
           if Length(HStr)=64 then begin
             HStr[63]:='.';
             HStr[64]:='.';
           end
           else HStr[Length(HStr)]:=' ';
           Titl:=HStr;
         end;
       end;
       Titl:=TitStr(Titl,1);
     end;
end;

{************************************************************************}
{* Routine:     ComInfo                                                 *}
{************************************************************************}
{* Inhalt:      Test auf verstecktes EXE und Identifikation als COM-Dat.*}
{* Definition:  Procedure ComInfo;                                      *}
{************************************************************************}

Procedure ComInfo;
begin
   if (FBuf.ExeKen=$5A4D) then ExeInfo
   else  
     with InfoRec do begin
       FTyp:=2;
       Kurz:='COM ';
       Lang:='DOS COM-Programm';
     end;
end;

{************************************************************************}
{* Routine:     PifInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion des Applikations-Namens aus Win- und DV-PIFs.*}
{* Definition:  Procedure PifInfo;                                      *}
{************************************************************************}

Procedure PifInfo;
Var      PifL      : Word;
         Test      : Integer;
begin
   with InfoRec do begin
     Kurz:='';
     PifL:=FileSeek(FH,0,2);
     FileSeek(FH,256,0);
     if ((PifL > 256) and (PifL < 1024)) then
       FileRead(FH,FBuf.DummyB,PifL-256);
     if ((PifL=369) and (SFWord(367)=$e060)) then begin
       Kurz:='PIF2';
       Lang:='Windows 2.x PIF';
     end;
     if ((PifL=545) and (SFWord(369)=$4d49)) then begin
       Kurz:='PIF3';
       Lang:='Windows 3.x PIF';
     end;
     if (PifL=416) then begin
       Kurz:='DVP ';
       Lang:='Deskview DVP';
     end;
     if (Kurz<>'') then begin
       FTyp:=2;
       Titl:='';
       EFlg:=0;
       EVer:=0;
       for Test:=2 to 31 do Titl:=Titl+FBuf.Dummy0[Test];
       if Kurz='PIF3' then Titl:=TitStr(Titl,0)
       else Titl:=TitStr(Titl,1);
     end;
   end;
end;

{************************************************************************}
{* Routine:     NlmInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl fr Novell ladbare Module           *}
{* Definition:  Procedure NlmInfo;                                      *}
{************************************************************************}

Procedure NlmInfo;
begin
   if (FBuf.NlmKen='NetWare Loadable Module') then
     with InfoRec do begin
       FTyp:=2;
       Kurz:='NLM ';
       Lang:='NetWare Loadable Module';
       Titl:=Copy(FBuf.NlmNam,1,64);
       Titl:=TitStr(Titl,1);
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:     VapInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl fr Novell VAPs                     *}
{* Definition:  Procedure VapInfo;                                      *}
{************************************************************************}

Procedure VapInfo;
Var      Adr       : Longint;
begin
   if (FBuf.ExeKen=$5A4D) then begin
     Adr:=FBuf.ExeGHe*16;
     FileSeek(FH,Adr,0);
     Test:=FileRead(FH,FBuf.DummyP,256);
     if (FBuf.VapKen='NWProc') then
       with InfoRec do begin
         FTyp:=2;
         Kurz:='VAP ';
         Lang:='Novell VAP';
         Titl:='';
         while ((Length(Titl)<64) and (Ord(FBuf.VapInf[Length(Titl)])>=$20)) do
           Titl:=Titl+FBuf.VapInf[Length(Titl)];
         Titl:=TitStr(Titl,1);
         EFlg:=0;
         EVer:=0;
       end;
   end;
end;

{************************************************************************}
{* Routine:     DevInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl fr Dos-Devicetreiber               *}
{* Definition:  Procedure DevInfo;                                      *}
{************************************************************************}

Procedure DevInfo;
Var      HStr      : String;
begin
   if (FBuf.ExeKen=$5A4D) then ExeInfo
   else begin
     HStr:=Copy(Devtest(0),1,64);
     if HStr<>'' then
       with InfoRec do begin
         FTyp:=2;
         Kurz:='DDEV';
         Lang:='DOS Device-Treiber';
         if Length(HStr)=64 then begin
           HStr[63]:='.';
           HStr[64]:='.';
         end
         else HStr[Length(HStr)]:=' ';
         Titl:=TitStr(HStr,1);
         EFlg:=0;
         EVer:=0;
       end;
   end;
end;

{************************************************************************}
{* Routine:     GroupInfo                                               *}
{************************************************************************}
{* Inhalt:      Extraktion von Titl fr WinGroups                       *}
{* Definition:  Procedure GroupInfo;                                    *}
{************************************************************************}

Procedure GroupInfo;
Const    WinGrpId  : Array[0..2] of Byte = ($50,$4D,$43);
Var      Adr       : Longint;
begin
   if BFCompare(Addr(FBuf),Addr(WinGrpId),2) then
     with InfoRec do begin
       FTyp:=2;
       Kurz:='WGRP';
       Lang:='Windows Group Datei';
       Titl:='';
       Adr:=FWord($16);
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,32);
       for Adr:=0 to 63 do Titl:=Titl+FBuf.Dummy0[Adr];
       Titl:=TitStr(Titl,0);
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:     TpuInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von ETit fr Turbo-Pascal-TPUs               *}
{* Definition:  Procedure TpuInfo;                                      *}
{************************************************************************}

Procedure TpuInfo;
Var      Adr       : Longint;
begin
   if CFCompare(Addr(FBuf),'TPU') then
     with InfoRec do begin
       FTyp:=2;
       Kurz:='TPU ';
       if FBuf.Dummy0[3]='4' then begin
         Kurz[4]:='4';
         Lang:='Turbo-Pascal 4.0 TPU';
       end;
       if FBuf.Dummy0[3]='5' then begin
         Kurz[4]:='5';
         Lang:='Turbo-Pascal 5.0 TPU';
       end;
       if FBuf.Dummy0[3]='6' then begin 
         Kurz[3]:='5';
         Kurz[4]:='5';
         Lang:='Turbo-Pascal 5.5 TPU';
       end;
       if FBuf.Dummy0[3]='9' then begin
         Kurz[4]:='6';
         Lang:='TP-6.0 bzw. TPW 1.x TPU';
       end;
       if FBuf.Dummy0[3]='Q' then begin
         Kurz[4]:='7';
         Lang:='Borland-Pascal 7.0 TPU';
       end;
       Adr:=FWord(8)+3;
       if FBuf.DummyA[3]< $36 then Dec(Adr,1);
       FileSeek(FH,Adr,0);
       Test:=FileRead(FH,FBuf.DummyP,64);
       Titl:=TitStr(FBuf.DumStr,1);
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:     ObjInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von ETit fr Intel-OBJs                      *}
{* Definition:  Procedure ObjInfo;                                      *}
{************************************************************************}

Procedure ObjInfo;
begin
   if (FBuf.ObjKen = $80) then
     with InfoRec do begin
       FTyp:=2;
       Kurz:='OBJ ';
       Lang:='Intel OBJ';
       Titl:=TitStr(FBuf.ObjNam,1);
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:     TTFInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von ETit fr Truetype TTF-Fontdateien        *}
{* Definition:  Procedure TTFInfo;                                      *}
{************************************************************************}

Procedure TTFInfo;
Var      Adr,Len   : Longint;
         i,j       : Byte;
begin
   if FBuf.TTFVer = $00000100 then begin
     Adr:=0;
     if Swap(FBuf.TTFTab)>15 then
       Test:=FileRead(FH,FBuf.DummyB,128);
     for i:=0 to Swap(FBuf.TTFTab) do
       if FBuf.TTFTag[i].Tag='name' then begin
         Adr:=LongI(FBuf.TTFTag[i].Adr);
         Len:=LongI(FBuf.TTFTag[i].Len);
         if Len > 4000 then Len:=4000;
       end;
     if Adr>0 then
       with InfoRec do begin
         FTyp := 2;
         Kurz := 'TTF ';
         Lang := 'Truetype Font';
         Titl := '';
         FileSeek(FH,Adr,0);
         Test:=FileRead(FH,FBuf.DummyP,Len);
         for i:=0 to Swap(FBuf.TTFNum)-1 do
           with (FBuf.TTFRec[i]) do begin
             if ((Swap(PId)=1) and (Swap(NId)=4)) then begin
               j:=0;
               while ((j<64) and (j<Swap(Len))) do begin
                 Titl:=Titl+FBuf.Dummy0[Swap(FBuf.TTFOfs)+Swap(Ofs)+j];
                 inc(j);
               end;
               break;
             end;
           end;
         Titl:=TitStr(Titl,0);
         EFlg:=0;
         EVer:=0;
       end;
   end;
end;

{************************************************************************}
{* Routine:     PfbInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von ETit fr Postscript PFB-Fontdateien      *}
{* Definition:  Procedure PfbInfo;                                      *}
{************************************************************************}

Procedure PfbInfo;
Var      i,j       : Byte;
begin
   if (CFCompare(Addr(FBuf.Dummy0[6]),'%!PS-AdobeFont')) or
      (CFCompare(Addr(FBuf.Dummy0[6]),'%!FontType1')) then
     with InfoRec do begin
       FTyp:=2;
       Kurz:='PFB ';
       Lang:='PostScript Font';
       Titl:='';
       for i:=15 to 25 do
       if FBuf.Dummy0[i]=':' then begin
         j:=i+2;
         while (Length(Titl)<64) and (FBuf.Dummy0[j]<>' ') do begin
           Titl:=Titl+FBuf.Dummy0[j];
           Inc(j,1);
         end;
       end;
       Titl:=TitStr(Titl,1);
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:     PfmInfo                                                 *}
{************************************************************************}
{* Inhalt:      Extraktion von ETit fr Postscript PFM-Fontdateien      *}
{* Definition:  Procedure PfmInfo;                                      *}
{************************************************************************}

Procedure PfmInfo;
begin
   if (CFCompare(Addr(FBuf.Dummy0[$c7]),'PostScript')) then
     with InfoRec do begin
       FTyp:=2;
       Kurz:='PFM ';
       Lang:='PostScript Font-Metric File';
       Titl:=TitStr('',0);
       move (FBuf.Dummy0[$d2],Titl[1],64);
       Titl:=TitStr(Titl,1);
       EFlg:=0;
       EVer:=0;
     end;
end;

