{************************************************************************}
{************************************************************************}
{* Modul:       AInfo-i.pas                                             *}
{************************************************************************}
{* Inhalt:      Extraktion von Zusatzinformationen fr AInfo            *}
{************************************************************************}
{* Funktion:    Extraktion der Horizontal-, Vertikal- und Farb-Auflsung*}
{*              sowie Paletten- und Pack-Informationen fr Bilder,      *}
{*              Titel, Instrumentenzahl und Lnge fr Musik, Titel und  *}
{*              Betriebssystem fr Programme.                           *}
{************************************************************************}
{* Version:     1.0.0.6                                                 *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       13.Apr.2003                                             *}
{* Vernderung: Bug-Fix in der JPEG-Erkennung neuerer Varianten         *}
{************************************************************************}
{* Revision:    0001 Erste Alpha-Version (bas. auf ADInfo.pas V0.52a)   *}
{************************************************************************}
{* Routinen:    LongI                                                   *}
{*              Long3                                                   *}
{*              FWord                                                   *}
{*              SFWord                                                  *}
{*              TitStr                                                  *}
{*              BFCompare                                               *}
{*              CFCompare                                               *}
{*              InitRiff                                                *}
{*              ExitRiff                                                *}
{*              InfoRiff                                                *}
{*              PcxInfo         (AI_Graph.Inc)                          *}
{*              DcxInfo         (AI_Graph.Inc)                          *}
{*              BmpTest         (AI_Graph.Inc)                          *}
{*              BmpInfo         (AI_Graph.Inc)                          *}
{*              RDibInfo        (AI_Graph.Inc)                          *}
{*              RleInfo         (AI_Graph.Inc)                          *}
{*              WpgInfo         (AI_Graph.Inc)                          *}
{*              MspInfo         (AI_Graph.Inc)                          *}
{*              IcoInfo         (AI_Graph.Inc)                          *}
{*              SciInfo         (AI_Graph.Inc)                          *}
{*              FliInfo         (AI_Graph.Inc)                          *}
{*              PicInfo         (AI_Graph.Inc)                          *}
{*              TgaInfo         (AI_Graph.Inc)                          *}
{*              RasInfo         (AI_Graph.Inc)                          *}
{*              TiffInfo        (AI_Graph.Inc)                          *}
{*              CutInfo         (AI_Graph.Inc)                          *}
{*              JpgInfo         (AI_Graph.Inc)                          *}
{*              GifInfo         (AI_Graph.Inc)                          *}
{*              LbmInfo         (AI_Graph.Inc)                          *}
{*              ImgInfo         (AI_Graph.Inc)                          *}
{*              MacInfo         (AI_Graph.Inc)                          *}
{*              AviInfo         (AI_Graph.Inc)                          *}
{*              DevTest         (AI_Appli.Inc)                          *}
{*              ExeInfo         (AI_Appli.Inc)                          *}
{*              ComInfo         (AI_Appli.Inc)                          *}
{*              PifInfo         (AI_Appli.Inc)                          *}
{*              NlmInfo         (AI_Appli.Inc)                          *}
{*              VapInfo         (AI_Appli.Inc)                          *}
{*              DevInfo         (AI_Appli.Inc)                          *}
{*              CmfInfo         (AI_Music.Inc)                          *}
{*              CmsInfo         (AI_Music.Inc)                          *}
{*              OrgInfo         (AI_Music.Inc)                          *}
{*              ModInfo         (AI_Music.Inc)                          *}
{*              RolInfo         (AI_Music.Inc)                          *}
{*              WavInfo         (AI_Music.Inc)                          *}
{*              VocInfo         (AI_Music.Inc)                          *}
{*              SndInfo         (AI_Music.Inc)                          *}
{*              MidiInfo        (AI_Music.Inc)                          *}
{*              ArjInfo         (AI_Archv.Inc)                          *}
{*              ArcInfo         (AI_Archv.Inc)                          *}
{*              ZipInfo         (AI_Archv.Inc)                          *}
{*              LzhInfo         (AI_Archv.Inc)                          *}
{*              ZooInfo         (AI_Archv.Inc)                          *}
{*              SqzInfo         (AI_Archv.Inc)                          *}
{*              RarInfo         (AI_Archv.Inc)                          *}
{*              DbfInfo         (AI_Sonst.Inc)                          *}
{*              WksInfo         (AI_Sonst.Inc)                          *}
{*              PTextInfo       (AI_Sonst.Inc)                          *}
{*              WordInfo        (AI_Sonst.Inc)                          *}
{*              HelpInfo        (AI_Sonst.Inc)                          *}
{*              GetInfo                                                 *}
{************************************************************************}

unit AInfo_i;
{$I-,S-}
{$M 8192,8192,655360}
interface
uses sysutils,windows
{$IFDEF Test}
,dialogs
{$ENDIF}
;

{$I AInfo_i.inc}

Type     BArrayPtr = ^BArray;
         CArrayPtr = ^CArray;
         BArray    = Array[0..255] of Byte;
         CArray    = Array[0..255] of Char;


Procedure GetInfo(const GFileName:String; Var InfoRec:DirRec);

{$IFDEF RiffInf}
Procedure ExitRiff;
{$ENDIF}

implementation

Var      Test      : Word;

{************************************************************************}
{* Routine:     LongI                                                   *}
{************************************************************************}
{* Inhalt:      Umwandlung eines Byte4-Langwortes in ein Langwort       *}
{* Definition:  Function LongI(x:Byte4):Longint                         *}
{************************************************************************}

Function LongI(x:Byte4):Longint;
begin
   LongI:=x[4]+Word(x[3])*256+x[2]*65536+x[1]*16777216;
end;

{************************************************************************}
{* Routine:     Long3                                                   *}
{************************************************************************}
{* Inhalt:      Umwandlung eines SB-3Byte-Wortes in ein Langwort        *}
{* Definition:  Function Long3(x:Byte3):Longint                         *}
{************************************************************************}

Function Long3(x:Byte3):Longint;
begin
   Long3:=x[1]+Word(x[2])*256+x[3]*65536;
end;

{************************************************************************}
{* Routine:     FWord                                                   *}
{************************************************************************}
{* Inhalt:      Extraktion eines Wortes aus dem FBuf.Dummy-Bereiches    *}
{* Definition:  Function FWord(x:Word):Word                             *}
{************************************************************************}

Function FWord(x:Word;const FBuf:FBufType):Word;
begin
   FWord:=FBuf.DummyA[x]+Word(FBuf.DummyA[x+1])*256;
end;

{************************************************************************}
{* Routine:     SFWord                                                  *}
{************************************************************************}
{* Inhalt:      Extraktion eines Wortes aus dem FBuf.Dummy-Bereiches    *}
{* Definition:  Function SFWord(x:Word):Word                            *}
{************************************************************************}

Function SFWord(x:Word;const FBuf:FBufType):Word;
begin
   SFWord:=FBuf.DummyA[x+1]+Word(FBuf.DummyA[x])*256;
end;

{************************************************************************}
{* Routine:     ANSIStr                                                 *}
{************************************************************************}
{* Inhalt:      Erzeugung eines Pascal ANSI-Strings ber Windows-API    *}
{* Definition:  Function ANSIStr(S:String):String;                      *}
{************************************************************************}

Function ANSIStr(S:ShortString):ShortString;
Var      HStr,H2Str: Array[0..255] of Char;
         P,P2      : PChar;
begin
   FillChar(HStr,SizeOf(HStr),#0);
   FillChar(H2Str,SizeOf(H2Str),#0);
   StrPCopy(HStr,S);
   P:=@HStr;
   P2:=@H2Str;
   OEMToANSIBuff(P,P2,Length(S));
   ANSIStr:=StrPas(H2Str);
end;

{************************************************************************}
{* Routine:     UpStr                                                   *}
{************************************************************************}
{* Inhalt:      Erzeugung eines Pascal UpCase-Strings ber Windows-API  *}
{* Definition:  Function UpStr(S:String):String;                        *}
{************************************************************************}

Function UpStr(S:ShortString):ShortString;
Var      HStr      : Array[0..255] of Char;
         P         : PChar;
begin
   FillChar(HStr,SizeOf(HStr),#0);
   StrPCopy(HStr,S);
   P:=@HStr;
   P:=StrUpper(P);
   UpStr:=StrPas(P);
end;

{************************************************************************}
{* Routine:     TitStr                                                  *}
{************************************************************************}
{* Inhalt:      Konvertierung eines Titelstringes in TString            *}
{* Definition:  Function TitStr(S:TString;Conv:Byte):TString            *}
{************************************************************************}

Function TitStr(S:TString;Conv:Byte):TString;
Var      HStr      : TString;
         i         : Byte;
begin
   i:=Pos(Chr(0),S);
   if i>0 then HStr:=Copy(S,1,i-1)
   else HStr:=S;
   if (Conv and $01)=$01 then TitStr:=ANSIStr(HStr)
   else TitStr:=HStr;
end;

{************************************************************************}
{* Routine:     BFCompare                                               *}
{************************************************************************}
{* Inhalt:      Vergleich zweier Bytefolgen                             *}
{* Definition:  Function BFCompare(X,Y:BArrayPtr;n:Byte):Boolean        *}
{************************************************************************}

Function BFCompare(X,Y:BArrayPtr;n:Byte):Boolean;
Var      i         : Byte;
         P         : Boolean;
begin
   P:=True;
   for i:=0 to n do
     if x^[i]<>Y^[i] then P:=False;
   BFCompare:=P;
end;

{************************************************************************}
{* Routine:     CFCompare                                               *}
{************************************************************************}
{* Inhalt:      Vergleich zweier Characterfolgen                        *}
{* Definition:  Function CFCompare(X:CArrayPtr;Y:String):Boolean        *}
{************************************************************************}

Function CFCompare(X:CArrayPtr;Y:String):Boolean;
Var      i         : Byte;
         P         : Boolean;
begin
   P:=True;
   for i:=1 to Length(Y) do
     if x^[i-1]<>Y[i] then P:=False;
   CFCompare:=P;
end;

{$IFDEF RiffInf}

{************************************************************************}
{* Routine:     InitRiff                                                *}
{************************************************************************}
{* Inhalt:      Vorinitialisieren des RiffInf-Feldes                    *}
{* Definition:  Procedure InitRiff                                      *}
{************************************************************************}

Procedure InitRiff;
Var     i          : Byte;
begin
   for i:=0 to 22 do begin
     RiffInf[i].Size:=100;
     RiffInf[i].Leng:=0;
     GetMem(RiffInf[i].Text, 100);
     FillChar(InfoRec,100,#0);
   end;
   InfoRec.Modi:=16;
end;

{************************************************************************}
{* Routine:     ExitRiff                                                *}
{************************************************************************}
{* Inhalt:      Freigeben der RiffInf-Strings                           *}
{* Definition:  Procedure ExitRiff                                      *}
{************************************************************************}

Procedure ExitRiff;
Var     i          : Byte;
begin
   for i:=0 to 22 do begin
     FreeMem(RiffInf[i].Text, RiffInf[i].Size);
     RiffInf[i].Size:=0;
     RiffInf[i].Leng:=0;
   end;
end;

{$ENDIF}

{************************************************************************}
{* Routine:     InfoRiff                                                *}
{************************************************************************}
{* Inhalt:      Auswertung der RIFF INFO-LIST-Chunks                    *}
{* Definition:  Procedure InfoRiff(Adr,Len1:Longint)                    *}
{************************************************************************}

Procedure InfoRiff(Adr,Len1:LongInt;Var FBuf:FBufType;FH:Integer;Var InfoRec:DirRec);
Var      Adr1      : LongInt;
         i         : Byte;

{$IFDEF RiffInf}
  Procedure GetRiff(i:Byte;Adr2:LongInt);
  begin
    RiffInf[i].Leng:=FBuf.RifLen;
    if RiffInf[i].Leng>80 then begin
      FreeMem(RiffInf[i].Text, RiffInf[i].Size);
      RiffInf[i].Size:=RiffInf[i].Leng+20;
      GetMem(RiffInf[i].Text, RiffInf[i].Size);
      FillChar(InfoRec, RiffInf[i].Size,#0);
    end;
    FileSeek(FH,Adr2+8,0);
    Test:=FileRead(FH,RiffInf[i].Text,RiffInf[i].Leng);
  end;
{$ENDIF}

  Function RiffStr:String;
  Var    Pos       : Word;
         MaxPos    : Word;
         HStr      : String;
  begin
    HStr:='';
    Pos:=8;
    MaxPos:=Pos + FBuf.RifLen;
    while (FBuf.DummyA[Pos] <> 0) and (Pos <= MaxPos) do begin
      HStr:=HStr+FBuf.DummyP[Pos];
      Inc(Pos);
    end;
    RiffStr:=HStr;
  end;

begin
   Adr1:=12;
   while Adr1<Len1 do begin
     FileSeek(FH,Adr+Adr1,0);
     Test:=FileRead(FH,FBuf.DummyP,256);
     if FBuf.DummyP[0] = 'I' then begin
       if (FBuf.RifTag = 'INAM') then InfoRec.Titl:=RiffStr;
       if (FBuf.RifTag = 'IART') then InfoRec.Crea:=RiffStr;
       if (FBuf.RifTag = 'ICMT') then InfoRec.Comm:=RiffStr;

{$IFDEF RiffInf}
       for i:=0 to 22 do
         if (FBuf.RifTag = RifInfTag[i]) then GetRiff(i,Adr+Adr1);
{$ENDIF}
       
       Adr1:=Adr1+8+FBuf.RifLen;
     end
     else Inc(Adr1);
   end;
end;

{$I ai_graph.inc}
{$IFDEF Ready}
{$I ai_appli.inc}
{$I ai_music.inc}
{$I ai_archv.inc}
{$I ai_sonst.inc}
{$ENDIF}
{************************************************************************}
{* Routine:     GetInfo                                                 *}
{************************************************************************}
{* Inhalt:      Auswahl der Info-Routine anhand der File-Extension      *}
{* Definition:  Procedure GetInfo(GFileName:String)                     *}
{************************************************************************}

Procedure GetInfo(Const GFileName:String;Var InfoRec:DirRec);
Var      E         : String[5];
         HStr      : Array[0..255] of Char;
         FH        : Integer;
         FBuf      : FBufType;
begin
   FillChar(InfoRec,SizeOf(InfoRec),#0);
   with InfoRec do begin
       StrPCopy(HStr,GFileName);
       FH:=FileOpen(HStr,of_Read+of_Share_Compat);
       if (FH=-1) then begin
         FH:=FileOpen(HStr,of_Read+of_Share_Deny_none);
       end;
       if FH>0 then begin
         FileRead(FH,FBuf.DummyP,256);

{         E:=UpStr(Copy(GFileName,Pos('.',GFileName)+1,3));}
         E:=UpStr(ExtractFileExt(GFileName));
         Kurz := E;
         FTyp := 0;

         if E = '.GIF' then GifInfo(FBuf,FH,InfoRec);

         if E = '.PCX' then PcxInfo(FBuf,FH,InfoRec);

         if E = '.DCX' then DcxInfo(FBuf,FH,InfoRec);

         if ((E = '.BMP') or (E = '.BB2')) then BmpInfo(FBuf,FH,InfoRec);

         if ((E = '.ICO') or (E = '.ICW') or (E = '.IC2') or
             (E = '.CUR') or (E = '.PTR')) then
           IcoInfo(FBuf,FH,InfoRec);

         if E = '.RLE' then RleInfo(FBuf,FH,InfoRec);

         if E = '.RIF' then RDibInfo(FBuf,FH,InfoRec);

         if ((E = '.LBM') or (E ='.IFF') or (E = '.BBM')) then LbmInfo(FBuf,FH,InfoRec);

         if E = '.IMG' then ImgInfo(FBuf,FH,InfoRec);

         if ((E = '.JPG') or (E = '.JIF')) then
           JpgInfo(FBuf,FH,InfoRec);

         if E = '.MSP' then MspInfo(FBuf,FH,InfoRec);

         if ((Copy(E,2,2) = 'SC') or (E = '.RIX') or (E ='.VMG')) then
           SciInfo(FBuf,FH,InfoRec);

         if ((E = '.FLI') or (E = '.FLC')) then
           FliInfo(FBuf,FH,InfoRec);

         if E = '.AVI' then AviInfo(FBuf,FH,InfoRec);

         if E = '.MOV' then MovInfo(FBuf,FH,InfoRec);

         if E = '.ANI' then AniInfo(FBuf,FH,InfoRec);

         if E = '.CUT' then CutInfo(FBuf,FH,InfoRec);

         if E = '.PIC' then PicInfo(FBuf,FH,InfoRec);

         if E = '.TGA' then TgaInfo(FBuf,FH,InfoRec);

         if E = '.PNG' then PngInfo(FBuf,FH,InfoRec);

         if E = '.RAS' then RasInfo(FBuf,FH,InfoRec);

         if E = '.WPG' then WpgInfo(FBuf,FH,InfoRec);

         if E = '.TIF' then TiffInfo(FBuf,FH,InfoRec);

         if ((E = '.MAC') or (E = '.PNT')) then
           MacInfo(FBuf,FH,InfoRec);
{$IFDEF Ready}
         if ((E = '.DBF') or (E = '.DBK') or (E = '.CAT')) then DbfInfo;

         if ((E = '.WKS') or (E = '.WK1') or (E = '.WQ1') or
             (E = '.WQ2')) then WksInfo;

         if ((E = '.EXE') or (E = '.DLL') or (E = '.DRV') or
             (E = '.FON') or (E = '.FOT') or (E = '.386') or
             (E = '.ADD') or (E = '.IFS') or (E = '.VBX') or
             (E = '.CPL') or (E = '.VXD') or (E = '.FLT') or
             (E = '.DMD') or (E = '.QTC')) then
           ExeInfo;

         if (FTyp = 0) and (E = '.SCR') then ExeInfo;

         if E = '.COM' then ComInfo;

         if ((E = '.NLM') or (E = '.DSK')) then
           NlmInfo;

         if E = '.VAP' then VapInfo;

         if ((E = '.SYS') or (E = '.DOS')) then DevInfo;

         if E = '.GRP' then GroupInfo;

         if ((E = '.PIF') or (E = '.DVP')) then
           PifInfo;

         if ((E = '.TPU') or (E = '.TPW') or (E = '.TPP')) then
           TpuInfo;

         if E = '.OBJ' then OBJInfo;

         if E = '.TTF' then TTFInfo;

         if E = '.PFB' then PfbInfo;

         if E = '.PFM' then PfmInfo;

         if E = '.CMF' then CmfInfo;

         if E = '.CMS' then CmsInfo;

         if E = '.ORG' then OrgInfo;

         if E = '.MOD' then ModInfo;

         if E = '.669' then G69Info;

         if E = '.S3M' then S3MInfo;

         if E = '.ROL' then RolInfo;

         if E = '.WAV' then WavInfo;

         if E = '.VOC' then VocInfo;

         if E = '.AU' then AUInfo;

         if ((E = '.SND') or (E = '.TUN') or (E = '.AIF')) then
           SndInfo;

         if E = '.MID' then MidiInfo;

         if ((E = '.TXT') or (E = '.WRI') or (E = '.SIK') or
             (E = '.DOC')) then
           WordInfo;

         if ((E = '.HLP') or (E = '.INF')) then HelpInfo;

         if ((E = '.ASM') or (E = '.PAS') or (E = '.CPP') or
             (E = '.LST') or (E = '.BAT') or (E = '.INI') or
             (E = '.RTF') or (E = '.DOC') or (E = '.INC') or
             (E = '.MAK') or (E = '.RC2') or (E = '.DLG') or
             (E = '.CMD') or (E = '.DIZ') or (E = '.HTM') or
             (E = '.RC') or (E = '.PS') or (E = '.C') or
             (E = '.H')) then
           PTextInfo;

         if E = '.ARJ' then ArjInfo;

         if E = '.ZIP' then ZipInfo;

         if ((E = '.ARC') or (E = '.PAK') or (E = '.SDN')) then ArcInfo;

         if ((E = '.LZH') or (E = '.ICE')) then LzhInfo;

         if E = '.ZOO' then ZooInfo;

         if E = '.SQZ' then SqzInfo;

         if E = '.RAR' then RarInfo;

         if E = '.GL' then Gl1Info;

         if E = '.PKT' then PktInfo;

         if E = '.MSG' then MsgInfo; {Mod. P.Karlsson}

         if E = '.BTM' then BtmInfo; {Mod. P.Karlsson}
{$ENDIF}

         FileClose(FH);
       end
       else begin
         Kurz:='Erro';
         StrPCopy(HStr,'Datei '+GFileName+' kann nicht geffnet werden');
{        MessageBox(Window,HStr,nil,
                    mb_AbortRetryIgnore+mb_ApplModal+mb_IconStop);}
       end;
   end;
end;

{************************************************************************}
{* Routine:     Hauptprogramm                                           *}
{************************************************************************}
{* Inhalt:      - (keine Vorinitialisierung notwendig)                  *}
{************************************************************************}

begin
end.

