{************************************************************************}
{* Include:     adinfo.inc                                              *}
{************************************************************************}
{* Inhalt:      Typ-Deklaration fr Modul adinfo.pas                    *}
{************************************************************************}
{* Version:     1.0.0.6  (AINFO)                                        *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       13.Apr.2003                                             *}
{************************************************************************}

Type
	 TString   = string[64];
	 DirRec    = packed record
		       Kurz: string[4];         {* Kurzbezeichnung      *}
		       Lang: TString;           {* Dateityp             *}
		       FTyp: Integer;           {* DateiKlasse          *}
		       Titl: TString;           {* Titel                *}
		       Crea: TString;           {* Autor/Komponist      *}
		       Comm: TString;           {* Kommentar            *}
		       Cmpr: TString;           {* Kompression          *}
		       Modi: Integer;           {* Modifizierbar        *}
		       GHor: Integer;           {* Auflsung horizontal *}
		       GVer: Integer;           {* Auflsung vertikal   *}
		       GCol: Longint;           {* Farbtiefe            *}
		       GPal: Longint;           {* Palleten-Farbtiefe   *}
		       GFrm: Word;              {* enthaltene Bilder    *}
		       GRat: Byte;              {* Bildrate [1/s]       *}
		       GSHo: Integer;           {* Pixelgre[]/dpi ho.*}
		       GSVe: Integer;           {* Pixelgre[]/dpi ve.*}
		       GFHo: Integer;           {* Startposition hor.   *}
		       GFVe: Integer;           {* Startposition ver.   *}  
		       EVer: Word;              {* notwendige Version   *}
		       EFlg: Word;              {* Flags                *}
		       SIns: Word;              {* Instrumente/Stimmen  *}
		       SLen: Integer;           {* Musiklnge [s]       *}
		       SSam: Word;              {* Samples [1/s]        *}
		       DLen: Word;              {* Datenfelder/-spalten *}
		       DSat: Word;              {* Datenstze/-zeilen   *}
		       DMem: Byte;              {* Memoflags            *}
		       DInd: Byte;              {* Indexflags           *}
		       PFil: Word;              {* enthaltene Dateien   *}
		       PPro: Word;              {* Kompressionsgrad     *}
		     end;

	 PDirRec   = ^DirRec;
	 Byte4     = Array[1..4] of Byte;
	 Char4     = Array[1..4] of Char;
	 Byte3     = Array[1..3] of Byte;
	 FBufPtr   = ^FBufType;
	 RiffRec   = packed record
		       Size: Word;
		       Leng: Word;
		       Text: PChar;
		     end;
	 CoffType  = packed record
		       Tag: Array [0..7] of Char;
		       Re1: Array [0..11] of Byte;
		       Pos: Longint;
		       Re2: Array [0..15] of Byte;
		     end;
	 TTFType   = packed record
		       Tag: Array[1..4] of Char;
		       CRC: Byte4;
		       Adr: Byte4;
		       Len: Byte4;
		     end;
	 TTFNTyp   = packed record
		       PId: Word;
		       EId: Word;
		       LId: Word;
		       NId: Word;
		       Len: Word;
		       Ofs: Word;
		     end;
	 TifType   = packed record
		       Tag: Word;
		       Typ: Word;
		       case Byte of
			 0: (ICnt: LongInt;
			     IOfs: Longint;);
			 1: (MCnt: Byte4;
			     MOfs: Byte4;);
			 2: (WDum: LongInt;
			     WOf1: Word;
			     WOf2: Word;);
			 3: (BDum: Longint;
			     BOf1: Byte;
			     BOf2: Byte;
			     BOf3: Byte;
			     BOf4: Byte;);
		     end;
	 TBufType  = packed record
		       case Byte of
			 0: (IW: Array[0..24] of Longint;);
			 1: (MW: Array[0..24] of Byte4;);
			 2: (WW: Array[0..49] of Word;);
			 3: (BW: Array[0..99] of Byte;);
			 4: (CW: Array[0..99] of Char;);
		     end;
	 IffType   = packed record
		       Typ: Array[1..4] of char;
		       Len: Byte4;
		       Par: Array[1..64] of char;
		     end;
	 MidType   = packed record
		       Evt: Word;
		       Typ: Byte;
		       case Boolean of
			 True : (Len: Byte;
				 Par: Array[1..64] of char;);
			 False: (Stg: TString;);
		     end;
	 GLType    = packed record
		       Len: LongInt;
		       Nam: Array[0..12] of Char;
		     end;
	 FBufType  = packed record
		       case Integer of
			 -1: (DummyP: Array[0..4095] of Char;);
			  0: (DummyA: Array[0..4095] of Byte;);
			  1: (DumStr: String[255];);
			  2: (DumCh4: Char4;);
			  3: (DumWrd: Word;);
			  4: (DumLIn: Array[0..255] of LongInt;);
			  5: (Dummy0: Array[0..255] of Char;
			      DummyB: Array[0..3839] of Char;);
			  6: (RifTag: Char4;
			      RifLen: LongInt;
			      RifTyp: Char4;
			      RifLst: Char4;);
			 40: (GifSig: Array[1..3] of Char;
			      GifVer: Array[1..3] of Char;
			      GifLSW: Word;
			      GifLSH: Word;
			      GifPF1: Byte;
			      GifBCI: Byte;
			      GifPAR: Byte;
			      GifDum: Array[13..4095] of Char;);
			 41: (PcxCre: Byte;
			      PcxVer: Byte;
			      PcxEnc: Byte;
			      PcxBpP: Byte;
			      PcxXMi: Word;
			      PcxYMi: Word;
			      PcxXMa: Word;
			      PcxYMa: Word;
			      PcxHRe: Word;
			      PcxVRe: Word;
			      PcxPa1: Array[1..16,1..3] of Byte;
			      PcxVMo: Byte;
			      PcxPla: Byte;
			      PcxBpL: Word;
			      PcxPaI: Byte;
			      PcxDum: Array[70..4095] of Char;);
			 42: (BmpTyp: Word;
			      BmpSiz: LongInt;
			      BmpRe1: Word;
			      BmpRe2: Word;
			      BmpOff: LongInt;
			      case BmpISi: LongInt of
				40: (BmpWid: LongInt;
				     BmpHei: LongInt;
				     BmpPla: Word;
				     BmpBit: Word;
				     BmpCom: LongInt;
				     BmpSiI: LongInt;
				     BmpXpM: LongInt;
				     BmpYpM: Longint;
				     BmpDum: Array[47..4095] of Char;);
				20: (BmcWid: Word;
				     BmcHei: Word;
				     BmcPla: Word;
				     BmcBit: Word;
				     BmcDum: Array[31..4095] of Char;););
			 43: (LbmIff: Char4;
			      LbmILe: LongInt;
			      LbmTyp: Char4;
			      LbmHea: Array[1..4] of Char;
			      LbmHLe: LongInt;
			      LbmBmX: Word;
			      LbmBmY: Word;
			      LbmXPo: Word;
			      LbmYPo: Word;
			      LbmBPl: Byte;
			      LbmMas: Byte;
			      LbmPac: Byte;
			      LbmRes: Byte;
			      LbmTCo: Word;
			      LbmAsX: Byte;
			      LbmAsY: Byte;
			      LbmAuX: Word;
			      LbmAuY: Word;
			      LbmDum: Array[39..4095] of Char;);
			 44: (WpgHea: Array[1..4] of Char;
			      WpgOfs: LongInt;
			      WpgPrg: Byte;
			      WpgTyp: Byte;
			      WpgVer: Word;
			      WpgDum: Array[12..4095] of Byte;);
			 45: (GemHea: Word;
			      GemLen: Word;
			      GemBpP: Word;
			      GemLeM: Word;
			      GemSiX: Word;
			      GemSiY: Word;
			      GemPiZ: Word;
			      GemEle: Word;
			      GemDum: Array[16..4095] of Byte;);
			 46: (TifCnt: Word;
			      TifTag: Array[1..32] of TifType;
			      TifDum: Array[386..4095] of Byte;);
			 47: (IcoKen: Word;
			      IcoTyp: Word;
			      IcoCnt: Word;
			      IcoSiX: Byte;
			      IcoSiY: Byte;
			      IcoCol: Byte;
			      IcoRes: Array[1..5] of Byte;
			      IcoSiz: Longint;
			      IcoOfs: Longint;
			      IcoDum: Array[22..4095] of Byte;);
			 48: (TgaILe: Byte;
			      TgaMTy: Byte;
			      TgaTyp: Byte;
			      TgaCMO: Word;
			      TgaCML: Word;
			      TgaCMS: Byte;
			      TgaIOX: Word;
			      TgaIOY: Word;
			      TgaWid: Word;
			      TgaHig: Word;
			      TgaPix: Byte;
			      TgaDes: Byte;
			      TgaDum: Array[18..4095] of Char;);
			 49: (PngHea: Array[1..8] of Byte;
			      PngHSi: Byte4;
			      PngIHe: Array[1..4] of Char;
			      PngSiX: Byte4;
			      PngSiY: Byte4;
			      PngBpP: Byte;
			      PngPTy: Byte;
			      PngCom: Byte;
			      PngFil: Byte;
			      PngInt: Byte;
			      PngDum: Array[100..4095] of Char;);
			 50: (AviIff: Array[1..4] of Char;
			      AviILe: LongInt;
			      AviTyp: Array[1..4] of Char;
			      AviHea: Array[1..4] of Char;
			      AviHLe: LongInt;
			      AviRe1: Array[0..87] of Byte;
			      AviSub: Array[1..4] of Char;
			      AviCod: Array[1..4] of Char;
			      AviRe2: Array[0..59] of Byte;
			      AviHor: Longint;
			      AviVer: Longint;
			      AviDum: Array[184..4095] of Char;);
			 51: (MovLen: Byte4;
			      MovTag: Array[1..4] of Char;
			      MovLe1: Byte4;
			      MovHTg: Array[1..4] of Char;
			      MovDum: Array[16..4095] of Char;);
			 80: (CmfFId: Array[1..4] of Char;
			      CmfVLo: Byte;
			      CmfVHi: Byte;
			      CmfOIB: Word;
			      CmfOMB: Word;
			      CmfTpQ: Word;
			      CmfCpS: Word;
			      CmfOMT: Word;
			      CmfOCN: Word;
			      CmfORe: Word;
			      CmfCTa: Array[1..16] of Byte;
			      CmfNIn: Word;
			      CmfTem: Word;
			      CmfDum: Array[40..4095] of Char;);
			 81: (ModTit: Array[0..19] of Char;
			      ModIns: Array[20..255] of Char;
			      ModPat: Byte;
			      ModTim: Byte;
			      ModPaA: Array[0..127] of Byte;
			      ModKen: Array[1..4] of Char;
			      ModRe1: Byte;
			      ModRe2: Byte;
			      ModTEf: Byte;
			      ModTPa: Byte;
			      ModDum: Array[394..4095] of Char;);
			 82: (MidKen: Array[1..4] of Char;
			      MidHLe: Byte4;
			      MidDum: Array[8..4095] of Char;);
			 83: (RolVHi: Word;
			      RolVLo: Word;
			      RolRe1: Array[1..40] of Byte;
			      RolTpB: Word;
			      RolBpM: Word;
			      RolXAx: ShortInt;
			      RolYAx: ShortInt;
			      RolRe2: Byte;
			      RolPrc: Byte;
			      RolRe3: Array[1..90] of Byte;
			      RolRe4: Array[1..38] of Byte;
			      RolRe5: Array[1..15] of Byte;
			      RolTem: Single;
			      RolTEv: ShortInt;
			      RolDum: Array[203..4095] of Char;);
			 84: (G69Ken: Array[1..2] of Char;
			      G69Tit: Array[1..108] of Char;
			      G69Sam: Byte;
			      G69Pat: Byte;
			      G69Dum: Array[112..4095] of Byte;);
			 85: (S3MTit: Array[1..28] of Char;
			      S3MKen: Byte;
			      S3MTy1: Byte;
			      S3MRe2: Array[1..2] of Byte;
			      S3MOrd: ShortInt;
			      S3MSam: ShortInt;
			      S3MPat: ShortInt;
			      S3MFlg: ShortInt;
			      S3MEVe: ShortInt;
			      S3MTVe: ShortInt;
			      S3MAKe: Array[1..4] of Char;
			      S3MDum: Array[48..4095] of Byte;);
			 90: (VocHea: Array[1..19] of Char;
			      VocRe1: Byte;
			      VocOfs: Word;
			      VocVer: Word;
			      VocIdn: Word;
			      VocRe2: Array[26..255] of Char;
			      VocTyp: Byte;
			      VocLen: Byte3;
			      VocDum: Array[4..768] of Byte;);
			 92: (SvxIff: Array[1..4] of Char;
			      SvxILe: LongInt;
			      SvxTyp: Array[1..4] of Char;
			      SvxHea: Array[1..4] of Char;
			      SvxHLe: Byte4;
			      SvxDum: Array[20..4095] of Char;);
			 93: (MacFst: Char;
			      MacTit: String[63];
			      MacTyp: Array[1..8] of Char;
			      MacDum: Array[73..4095] of Char;);
			 94: (WavHea: Array[1..4] of Char;
			      WavHLe: LongInt;
			      WavFor: Word;
			      WavCha: Word;
			      WavSpS: LongInt;
			      WavMSp: LongInt;
			      WavAli: Word;
			      WavBpS: Word;
			      WavDum: Array[24..4095] of Char;);
			121: (PktONo: Word;
			      PktDNo: Word;
			      PktDaY: Word;
			      PktDaM: Word;
			      PktDaT: Word;
			      PktTiH: Word;
			      PktTiM: Word;
			      PktTiS: Word;
			      PktMax: Word;
			      PktPId: Word;
			      PktONe: Word;
			      PktDNe: Word;
			      PktPCo: Byte;
			      PktPVe: Byte;
			      PktPWD: Array [1..8] of Char;
			      PktOQZ: Word;
			      PktDQZ: Word;
			      PktRes: Array [1..2] of Byte;
			      PktCaV: Word;
			      PktPCh: Byte;
			      PktPVm: Byte;
			      PktCaW: Word;
			      PktOZo: Word;
			      PktDZo: Word;
			      PktOPt: Word;
			      PktDPt: Word;
			      PktDum: Array [54..4095] of Char;);
			122: (MsgFrm: Array [1..36] of Char; {fromusername}
			      MsgToN: Array [1..36] of Char; {tousername}
			      MsgSub: Array [1..72] of Char; {subject}
			      MsgDat: Array [1..10] of Char; {datetime}
			      MsgRea: Word; {timesread}
			      MsgDNo: Word; {destnode}
			      MsgONo: Word; {orignode}
			      MsgCst: Word; {Cost}
			      MsgONe: Word; {orignet}
			      MsgDNe: Word; {destnet}
			      MsgDZo: Word; {destzone - optional}
			      MsgOZo: Word; {origzone - optional}
			      MsgDPo: Word; {destpoint - optional}
			      MsgOPo: Word; {origpoint - optional}
			      MsgRTo: Word; {replyto}
			      MsgAtt: Word; {attribute}
			      MsgNxt: Word; {nextreply}
			      MsgDum: Array [180..4095] of Char;);
			160: (DbfKen: Byte;
			      DbfDat: Array[0..2] of Byte;
			      DbfSat: Longint;
			      DbfHSi: Word;
			      DbfSSi: Word;
			      DbfRe1: Array[0..1] of Byte;
			      DbfTra: Byte;
			      DbfCry: Byte;
			      DbfNet: Array[0..11] of Byte;
			      DbfMdx: Byte;
			      DbfRe2: Array[0..2] of Byte;
			      DbfFld: Array[32..4095] of Byte;);     
			200: (ExeKen: Word;
			      ExeGlP: Word;
			      ExeGPg: Word;
			      ExeARe: Word;
			      ExeGHe: Word;
			      ExeMiP: Word;
			      ExeMaP: Word;
			      ExeSSS: Word;
			      ExeSSP: Word;
			      ExePrf: Word;
			      ExeSIP: Word;
			      ExeSCS: Word;
			      ExeSRe: Word;
			      ExeOvl: Word;
			      ExeRes: Array[28..59] of Char;
			      ExeAdN: Longint;
			      ExeDum: Array[64..4095] of Char;);
			201: (ExnKen: Word;
			      ExnLnV: Byte;
			      ExnLnR: Byte;
			      ExnOET: Word;
			      ExnLET: Word;
			      ExnRe1: Array[1..4] of Byte;
			      ExnFl1: Word;
			      ExnADS: Word;
			      ExnGLH: Word;
			      ExnGSS: Word;
			      ExnSIP: Word;
			      ExnSCS: Word;
			      ExnSSP: Word;
			      ExnSSS: Word;
			      ExnASe: Word;
			      ExnARe: Word;
			      ExnARN: Word;
			      ExnOSe: Word;
			      ExnORe: Word;
			      ExnORN: Word;
			      ExnOMR: Word;
			      ExnOIN: Word;
			      ExnONN: LongInt;
			      ExnAVE: Word;
			      ExnAli: Word;
			      ExnARS: Word;
			      ExnFl2: Byte;
			      ExnFl3: Byte;
			      ExnAFL: Word;
			      ExnLFL: Word;
			      ExnRes: Word;
			      ExnVer: Word;
			      ExnDum: Array[64..4095] of Char;);
			202: (ExlKen: Word;
			      ExlLnV: Byte;
			      ExlLnR: Byte;
			      ExlEFL: LongInt;
			      ExlCPU: Word;
			      ExlTOS: Word;
			      ExlMoV: LongInt;
			      ExlMoT: LongInt;
			      ExlAMP: LongInt;
			      ExlSIP: LongInt;
			      ExlSCS: LongInt;
			      ExlSSP: LongInt;
			      ExlSSS: LongInt;
			      ExlPSi: LongInt;
			      ExlBLP: LongInt;
			      ExlFSS: LongInt;
			      ExlFSC: LongInt;
			      ExlLSS: LongInt;
			      ExlLSC: LongInt;
			      ExlOOT: LongInt;
			      ExlEOT: LongInt;
			      ExlRe1: Longint;
			      ExlRe2: LongInt;
			      ExlORT: LongInt;
			      ExlERT: LongInt;
			      ExlORN: LongInt;
			      ExlOET: LongInt;
			      ExlOMD: LongInt;
			      ExlEMD: LongInt;
			      ExlRe3: LongInt;
			      ExlRe4: LongInt;
			      ExlOIM: Longint;
			      ExlEIO: LongInt;
			      ExlOPN: LongInt;
			      ExlOPC: LongInt;
			      ExlOPP: LongInt;
			      ExlAPP: LongInt;
			      ExlONN: LongInt;
			      ExlANN: LongInt;
			      ExlNNC: LongInt;
			      ExlADA: LongInt;
			      ExlODI: Longint;
			      ExlADI: LongInt;
			      ExlNPI: LongInt;
			      ExlNDI: LongInt;
			      ExlEHA: LongInt;
			      ExlRe5: Array[1..12] of Byte;
			      ExlVeI: Longint;
			      ExlDLP: Longint;
			      ExlDId: Word;
			      ExlVer: Word;
			      ExlDum: Array[196..4095] of Char;);
			203: (NlmKen: Array[0..22] of Char;
			      NlmRe1: Array[0..4] of Byte;
			      NlmDat: String[12];
			      NlmRe2: Array[0..88] of Byte;
			      NlmNam: String[64];
			      NlmDum: Array[196..4095] of Char;);
			204: (VapKen: Array[1..6] of Char;
			      VapRe1: Array[0..27] of Byte;
			      VapInf: Array[0..63] of Char;
			      VapDum: Array[98..4095] of Char;);
			205: (DevLOf: Word;
			      DevLSe: Word;
			      DevAtt: Word;
			      DevStR: Word;
			      DevInR: Word;
			      DevNam: Array[1..8] of Char;
			      DevDum: Array[18..4095] of Char;);
			206: (CofKen: Word;
			      CofRe1: Array[2..5] of Byte;
			      CofAnz: Word;
			      CofRe2: Array[8..19] of Byte;
			      CofOfs: Word;
			      CofRe3: Array[22..255] of Byte;
			      CofEnt: Array[1..20] of CoffType;
			      CofDum: Array[992..3000] of Char;);
			220: (ObjKen: Byte;
			      ObjLen: Word;
			      ObjNam: String[40];
			      ObjDum: Array[44..4095] of Char;);
			230: (TTFVer: LongInt;
			      TTFTab: Word;
			      TTFRan: Word;
			      TTFSel: Word;
			      TTFShi: Word;
			      TTFTag: Array[0..20] of TTFType;
			      TTFDum: Array[348..4095] of Char;);
			231: (TTFFor: Word;
			      TTFNum: Word;
			      TTFOfs: Word;
			      TTFRec: Array[0..50] of TTFNTyp;);
			240: (ZipKen: Word;
			      case ZipTyp: Word of
				$0403: (ZilVer: Word;
					ZilFlg: Word;
					ZilMet: Word;
					ZilLTi: Word;
					ZilLDa: Word;
					ZilCRC: Longint;
					ZilCSi: Longint;
					ZilUSi: Longint;
					ZilNSi: Word;
					ZilESi: Word;
					ZilDum: Array[30..4095] of Byte;);
				$0201: (ZigVe1: Word;
					ZigVe2: Word;
					ZigFlg: Word;
					ZigMet: Word;
					ZigLTi: Word;
					ZigLDa: Word;
					ZigCRC: Longint;
					ZigCSi: Longint;
					ZigUSi: Longint;
					ZigNSi: Word;
					ZigESi: Word;
					ZigFSi: Word;
					ZigDsk: Word;
					ZigIFA: Word;
					ZigEFA: Longint;
					ZigOfs: Longint;
					ZigDum: Array[46..4095] of Byte;);
				$0605: (ZipADs: Word;
					ZipDDs: Word;
					ZipAED: Word;
					ZipAET: Word;
					ZipDSi: Longint;
					ZipOfs: Longint;
					ZipFSi: Word;););
			241: (ArcKen: Byte;
			      ArcTyp: Byte;
			      ArcNam: Array[0..12] of Char;
			      ArcCSi: Longint;
			      ArcDat: Word;
			      ArcTim: Word;
			      ArcCRC: Word;
			      ArcUSi: Longint;
			      ArcDum: Array[29..4095] of Byte;);
			242: (ArjKen: Word;
			      ArjHSi: Word;
			      ArjFHS: Byte;
			      ArjAVe: Byte;
			      ArjMVe: Byte;
			      ArjHOS: Byte;
			      ArjFlg: Byte;
			      ArjMet: Byte;
			      ArjTyp: Byte;
			      ArjRes: Byte;
			      ArjDat: Longint;
			      ArjCSi: Longint;
			      ArjUSi: Longint;
			      ArjCRC: Longint;
			      ArjFPF: Word;
			      ArjFAM: Word;
			      ArjHDa: Word;
			      ArjDum: Array[34..4095] of Byte;);
			243: (LzhHSi: Byte;
			      LzhRes: Byte;
			      LzhMet: Array[0..4] of Char;
			      LzhCSi: Longint;
			      LzhUSi: Longint;
			      LzhDat: Longint;
			      LzhDum: Array[20..4095] of Byte;);
			244: (ZooRe1: Array[0..3] of Char;
			      ZooRe2: Byte;
			      ZooKe1: Byte;
			      ZooOfs: Longint;
			      ZooRe3: Array[0..7] of Byte;
			      ZooCRC: Word;
			      ZooUSi: Longint;
			      ZooCSi: Longint;
			      ZooDum: Array[28..4095] of Byte;);
			245: (case SqzTyp: Byte of
				$01: (SqzCUS: Word;
				      SqzCCS: Word;
				      SqzCMe: Byte;
				      SqzCCR: Longint;
				      SqzCDu: Array[10..4095] of Byte;);
				$13: (SqzASu: Byte;
				      SqzMet: Byte;
				      SqzCSi: Longint;
				      SqzUSi: Longint;
				      SqzDat: Longint;
				      SqzAtt: Byte;
				      SqzCRC: Longint;
				      SqzDum: Array[20..4095] of Byte;););
			246: (case Byte of
				$01: (RarHId: Longint;
				      RarHLe: Word;
				      RarTyp: Byte;
				      RarHDu: Array[7..4095] of Byte;);
				$02: (RarCSi: Longint;
				      RarUSi: Longint;
				      RarCRC: Word;
				      RarFLe: Word;
				      RarTim: Longint;
				      RarAtt: Byte;
				      RarFlg: Byte;
				      RarVer: Byte;
				      RarNLe: Byte;
				      RarMet: Byte;
				      RarDum: Array[21..4095] of Byte;););
			247: (RanCRC: Word;
			      RanTyp: Byte;
			      RanFlg: Word;
			      RanHLe: Word;
			      RanCSi: Longint;
			      RanUSi: Longint;
			      RanDum: Array[15..4095] of Byte;);
			248: (Gl1HSi: Word;
			      Gl1Hea: Array[0..19] of GlType;
			      Gl1Dum: Array[342..4095] of Byte;);
			249: (T64Ken: Array[1..32] of Char; { Kennung='C64'.. }
			      T64Ver: Word; { version = $0200 }
			      T64Siz: Word; { # of entries }
			      T64Use: Word; { used entries }
			      T64Unu: Word; { not used }
			      T64Dsc: Array[1..40] of Char; { Description }
			      T64Dum: Array[64..4095] of Char;);
		     end;

Const    RifInfTag : Array[0..24] of Char4 =
		     ('INAM','ISBJ','IART','ICRD','IDIM',
		      'IGNR','IMED','IARL','ICMS','ICMT',
		      'ICOP','ICRP','ISRC','ISRF','ITCH',
		      'ISFT','IPRD','IDPI','ILAT','ISHP',
		      'IPCT','IENG','IKEY','I   ','I   ');

{$IFDEF RiffInf}         
	 RiffInf   : Array[0..24] of RiffRec;
{$ENDIF}
