unit AInfo_f;

interface

uses
  Windows, Messages, ActiveX, ComObj, CommCtrl, ShlObj, ShellAPI, AInfo_I;

{$R AINFO_F.RES}
type
  TAInfoSheet = class(TComObject, IShellExtInit, IShellPropSheetExt)
  private
    FFileName: array[0..MAX_PATH] of Char;
    PSP      : TPropSheetPage;
    HPage    : HPropSheetPage;
    InfoRec  : DirRec;
    FCnt     : UINT;
  protected
    {hier IShellExtInit-Methoden deklarieren}
    function Initialize(pidlFolder: PItemIDList;
                        ldobj:IDataObject;
                        hKeyProgID: HKEY): HResult; stdcall;
    
    {hier IShellPropSheetExt-Methoden deklarieren}
    function AddPages(lpfnAddPage: TFNAddPropSheetPage;
                      lParam: LPARAM): HResult; stdcall;
    function ReplacePage(uPageID: UINT;
                         lpfnReplaceWith: TFNAddPropSheetPage;
                         lParam: LPARAM): HResult; stdcall;
  end;

const
  Class_AInfoSheet: TGUID = '{C77060A0-2EDB-11D4-B19B-0080AD1E521B}';

implementation

uses ComServ,sysutils;


function AInfoDlgProc(Wnd: HWnd;
                      Msg: UINT;
                      WParam: WPARAM;
                      LParam: LPARAM): UINT; stdcall;
Var    HStr: Array[0..80] of Char;
begin
  Result := 1;
  case Msg of
    WM_INITDIALOG:
      begin
        with PDirRec(PPropSheetPage(LParam)^.LParam)^ do begin
          StrPCopy(HStr,Lang);
          SetDlgItemText(Wnd, 101, HStr);
          SetDlgItemInt(Wnd, 102, GHor, False);
          SetDlgItemInt(Wnd, 103, GVer, False);
          SetDlgItemInt(Wnd, 104, GCol, False);
          StrPCopy(HStr,Cmpr);
          SetDlgItemText(Wnd, 105, HStr);
          if Comm <> '' then begin
            SetDlgItemText(Wnd, 6, 'Hinweis:');
            StrPCopy(HStr,Comm);
            SetDlgItemText(Wnd, 106, HStr);
          end;
        end;
        Exit;
      end;
    WM_NOTIFY:
      begin
        SetWindowLong (Wnd, DWL_MSGRESULT, 0);
        Exit;
      end;
  end;
  Result:=0;
end;


function TAInfoSheet.Initialize(pidlFolder: PItemIDList;
                                ldobj: IdataObject;
                                hkeyProgId: HKey): HResult; stdcall;
var
  StgMedium: TStgMedium;
  FormatEtc: TFormatEtc;
begin
  // Fail the call if ldobj is Nil.
  if (ldobj = nil) then begin
    Result := E_INVALIDARG;
    Exit;
  end;

  with FormatEtc do begin
    cfFormat := CF_HDROP;
    ptd      := nil;
    dwAspect := DVASPECT_CONTENT;
    lindex   := -1;
    tymed    := TYMED_HGLOBAL;
  end;
  // Render the data referenced by the IDataObject pointer to an HGLOBAL
  // storage medium in CF_HDROP format.
  Result := ldobj.GetData(FormatEtc, StgMedium);
  if Failed(Result) then
    Exit;
  // If only one file is selected, retrieve the file name and store it in
  // FFileName. Otherwise fail the call.
  if (DragQueryFile(StgMedium.hGlobal, $FFFFFFFF, nil, 0) = 1) then begin
    DragQueryFile(StgMedium.hGlobal, 0, FFileName, SizeOf(FFileName));
    Result := NOERROR;
  end
  else begin
    FFileName[0] := #0;
    Result := E_FAIL;
  end;
  ReleaseStgMedium(StgMedium);
end;

function TAInfoSheet.AddPages(lpfnAddPage: TFNAddPropSheetPage;
                              lParam: LPARAM): HResult; stdcall;
begin

  GetInfo(FFileName,InfoRec);

  FCnt := ComServer.ObjectCount;

  PSP.dwSize    := sizeof(PSP);
  PSP.dwFlags   := PSP_USEREFPARENT or PSP_USETITLE;
  PSP.hInstance := HInstance;
  PSP.pszTemplate := 'ImageProperties';
  PSP.pszTitle    := 'Advanced Infos';
  PSP.pfnDlgProc  := @AInfoDlgProc;
  PSP.lParam      := Integer(@InfoRec); {?}
  PSP.pcRefParent := @comserver.objectcount;  {@FCnt ?}

  HPage := CreatePropertySheetPage(PSP);

  if (HPage <> nil) then
    if (not lpfnAddPage(HPage, lParam)) then
      DestroyPropertySheetPage(HPage);
  Result := NOERROR;
end;

function TAInfoSheet.ReplacePage(uPageId: UINT;
                                 lpfnReplaceWith: TFNAddPropSheetPage;
                                 lParam: LPARAM): HResult; stdcall;
begin
  Result := E_FAIL;
end;


initialization
  DisableThreadLibraryCalls(hInstance);
  TComObjectFactory.Create(ComServer, TAInfoSheet, Class_AInfoSheet,
    'AInfo', 'Advanced-Info', ciMultiInstance, tmApartment);
end.
