unit AI_Inst2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, registry;

type
  TForm2 = class(TForm)
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure ClickCheckBox(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

  TRegExt = record
     Extension: string[16];
     Alias    : string[80];
     AltAinfo : Boolean;
     NeuAinfo : Boolean;
  end;

var
  Form2: TForm2;
  RegExt: Array[1..12] of TRegExt;
  Regist: TRegistry;

Procedure GetAInfoExt;
Procedure SetAInfoExt;

implementation

{$R *.DFM}

const ShExErw : string[64]='\ShellEx\PropertySheetHandlers\AdvancedInfo';

Procedure SetCBox(i:Integer);
begin
  with Form2 do
    TCheckBox(FindComponent('CheckBox'+IntToStr(i))).Checked:=
      RegExt[i].NeuAInfo;
end;

Procedure GetAInfoExt;
Var i: Integer;
begin
  RegExt[ 1].Extension:='\.bmp';
  RegExt[ 2].Extension:='\.gif';
  RegExt[ 3].Extension:='\.jpg';
  RegExt[ 4].Extension:='\.pcx';
  RegExt[ 5].Extension:='\.png';
  RegExt[ 6].Extension:='\.tga';
  RegExt[ 7].Extension:='\.tif';
  RegExt[ 8].Extension:='\.ico';
  RegExt[ 9].Extension:='\*';
  RegExt[10].Extension:='\.avi';
  RegExt[11].Extension:='\.fli';
  RegExt[12].Extension:='\.mov';

  Regist:=TRegistry.Create;
  Regist.RootKey:=HKEY_CLASSES_ROOT;
  for i:=1 to 12 do begin
    RegExt[i].Alias:='';
    RegExt[i].AltAinfo:=False;
    RegExt[i].NeuAinfo:=False;

    if (Regist.OpenKeyReadOnly(RegExt[i].Extension)) then begin
      RegExt[i].Alias:=Regist.ReadString('');
      if RegExt[i].Alias='' then
        RegExt[i].Alias:=RegExt[i].Extension
      else
        RegExt[i].Alias:='\'+RegExt[i].Alias;
{      ShowMessage(RegExt[i].Extension+' '+RegExt[i].Alias);}
      if (Regist.OpenKeyReadOnly(RegExt[i].Alias+ShExErw)) then begin
        RegExt[i].AltAinfo:=True;
        RegExt[i].NeuAinfo:=True;
      end;
    end;
    SetCBox(i);
  end;
  Regist.Free;
end;

Procedure SetAInfoExt;
Var i: Integer;
begin
  Regist:=TRegistry.Create;
  Regist.RootKey:=HKEY_CLASSES_ROOT;
  for i:=1 to 12 do begin
    if RegExt[i].AltAInfo and not RegExt[i].NeuAInfo then begin
      Regist.DeleteKey(RegExt[i].Alias+ShExErw);
    end;
    if RegExt[i].NeuAInfo and not RegExt[i].AltAInfo then begin
      Regist.CreateKey(RegExt[i].Alias+ShExErw);
      Regist.OpenKey(RegExt[i].Alias+ShExErw,True);
      Regist.WriteString('','{C77060A0-2EDB-11D4-B19B-0080AD1E521B}');
    end;
  end;
  Regist.Free;
end;

procedure TForm2.ClickCheckBox(Sender: TObject);
Var i:Byte;
{    H:String[20];}
    P:Boolean;
begin
  if Visible then begin
   P:=TCheckBox(Sender).Checked;
{   if (P) then H:=' ist on'
   else        H:=' ist off';}
   for i:=1 to 12 do begin
     if (FindComponent('CheckBox'+IntToStr(i))=Sender) then begin
{       ShowMessage('Checkbox '+Chr(64+i)+H);}
       RegExt[i].NeuAInfo:=P;
     end;
   end;
  end;
end;

end.
