unit CKRSForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, registry;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    RadioGroup1: TRadioGroup;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    Regist1: TRegistry;
    Regist2: TRegistry;
    GKey : AnsiString;
    Key1 : AnsiString;
    Key2 : AnsiString;
    RTyp : AnsiString;
    F: Text;
    Id : AnsiString;
    Prop : AnsiString;
    Bold : AnsiString;
    Capt : AnsiString;
    Widt : AnsiString;
    Font : AnsiString;
    Size : AnsiString;
    Col : AnsiString;
    Akt : AnsiString;
    Function GetToken (Var Zeile:AnsiString; Delimiter:AnsiString): AnsiString;
    Procedure ParseLine(Zeile: AnsiString);
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
Function TForm1.GetToken (Var Zeile:AnsiString; Delimiter:AnsiString): AnsiString;
Var i: Integer;
begin
   i:=AnsiPos(Delimiter,Zeile);
   if i>0 then begin
     Result:=Copy(Zeile,
                  i+Length(Delimiter),
                  Length(Zeile)-(i-1)-Length(Delimiter));
     SetLength(Zeile,i-1);
   end
   else begin
     Result:=Zeile;
     SetLength(Zeile,0);
   end;
end;

Procedure TForm1.ParseLine(Zeile: AnsiString);
Var TempZ,TempHZ:AnsiString;
begin
   try
    TempZ:=Copy(Zeile,2,Length(Zeile)-1);
    TempHZ:=GetToken(TempZ,'","');
    ID:=TempZ;
    TempZ:=GetToken(TempHZ,'","');
    Col:=TempHZ;
    TempHZ:=GetToken(TempZ,'","');
    Akt:=TempZ;
    TempZ:=GetToken(TempHZ,'","');
    Bold:=TempHZ;
    TempHZ:=GetToken(TempZ,'","');
    Capt:=TempZ;
    TempZ:=GetToken(TempHZ,'","');
    Widt:=TempHZ;
    TempHZ:=GetToken(TempZ,'","');
    Font:=TempZ;
    Size:=Copy(TempHZ,1,Length(TempHZ)-1);
    Prop:=Col+'-'+Akt;
   except
   end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
Var Zeile: AnsiString;
    P: Boolean;
begin
  GKey:='Software\VB and VBA Program Settings\ComicKeeper\2.0\Settings\';
  Regist1:=TRegistry.Create;
  Regist1.RootKey:=HKEY_CURRENT_USER;
  Regist2:=TRegistry.Create;
  Regist2.RootKey:=HKEY_CURRENT_USER;
  if RadioGroup1.ItemIndex=0 then RTyp:='Table\';
  if RadioGroup1.ItemIndex=1 then RTyp:='List\';
  if RadioGroup1.ItemIndex=2 then RTyp:='Comic\';
  Key1:=GKey+RTyp+'Properties';
  P:=Regist1.OpenKey(Key1,False);
  AssignFile(F,Edit1.Text);
  Reset(F);
  While not EOF(F) do begin
    Readln(F,Zeile);
    ParseLine(Zeile);
    Regist1.WriteString(Id,Prop);
    Key2:=GKey+RTyp+Col;
    P:=Regist2.OpenKey(Key2,True);
    Regist2.WriteString('Bold',Bold);
    Regist2.WriteString('Caption',Capt);
    if RadioGroup1.ItemIndex=0 then Regist2.WriteString('ColWidth',Widt);
    Regist2.WriteString('Font',Font);
    Regist2.WriteString('FontSize',Size);
    Regist2.CloseKey;
  end;
  CloseFile(F);
  Regist1.Destroy;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
Var P: Boolean;
    I: Integer;
begin
  GKey:='Software\VB and VBA Program Settings\ComicKeeper\2.0\Settings\';
  Regist1:=TRegistry.Create;
  Regist1.RootKey:=HKEY_CURRENT_USER;
  Regist2:=TRegistry.Create;
  Regist2.RootKey:=HKEY_CURRENT_USER;
  if RadioGroup1.ItemIndex=0 then RTyp:='Table\';
  if RadioGroup1.ItemIndex=1 then RTyp:='List\';
  if RadioGroup1.ItemIndex=2 then RTyp:='Comic\';
  Key1:=GKey+RTyp+'Properties';
  P:=Regist1.OpenKeyReadOnly(Key1);
  AssignFile(F,Edit1.Text);
  Rewrite(F);
  for i:=0 to 37 do begin
    Id:=InttoStr(i);
    Prop:=Regist1.ReadString(Id);
    Col:=Copy(Prop,1,Pos('-',Prop)-1);
    Akt:=Copy(Prop,Pos('-',Prop)+1,1);
    Key2:=GKey+RTyp+Col;
    P:=Regist2.OpenKeyReadOnly(Key2);
    Bold:=Regist2.ReadString('Bold');
    if Bold='' then Bold:='0';
    Capt:=Regist2.ReadString('Caption');
    Widt:=Regist2.ReadString('ColWidth');
    if Widt='' then Widt:='2';
    Font:=Regist2.ReadString('Font');
    if Font='' then Font:='Comic Sans MS';
    Size:=Regist2.ReadString('FontSize');
    if Size='' then
      case RadioGroup1.ItemIndex of
        0 : Size:='8';
        1 : Size:='10';
        2 : Size:='12';
      end;
    Regist2.CloseKey;
    Writeln(F,'"',Id,'","',Col,'","',Akt,'","',Bold,'","',Capt,'","',Widt,'","',Font,'","',Size,'"');
  end;
  CloseFile(F);
  Regist1.Destroy;
  Regist2.Destroy;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  OpenDialog1.Filter:='CK Report-Description (*.crs)|*.crs';
  if OpenDialog1.Execute then begin
    Edit1.Text:=OpenDialog1.Filename;
  end;
end;

end.
